/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public enum ShorthandParser {
    NUMERIC_RANGE{

        @Override
        public Iterator<String> extract(String input) throws NumberFormatException {
            int index = input.indexOf(45);
            if (index == -1 || index == 0 || index == input.length() - 1) {
                return null;
            }
            return new RangeIterator(Integer.parseInt(input.substring(0, index)), Integer.parseInt(input.substring(index + 1))){

                @Override
                protected String toString(int i) {
                    return Integer.toString(i);
                }
            };
        }
    }
    ,
    CHARACTER_RANGE{

        @Override
        public Iterator<String> extract(String input) {
            if (input.length() != 3 || input.charAt(1) != '-') {
                return null;
            }
            return new RangeIterator(input.charAt(0), input.charAt(2)){

                @Override
                protected String toString(int i) {
                    return Character.toString((char)i);
                }
            };
        }
    }
    ,
    LIST{
        private final Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)new String(new char[]{',', '|'}))).omitEmptyStrings();

        @Override
        public Iterator<String> extract(String input) {
            if (ShorthandParser.indexOfEither(input, ',', '|') == -1) {
                return Iterators.singletonIterator((Object)input);
            }
            return this.splitter.split((CharSequence)input).iterator();
        }
    };

    private static final char OPEN_GROUP = '{';
    private static final char CLOSE_GROUP = '}';
    private static final char OPEN_GROUP_2 = '(';
    private static final char CLOSE_GROUP_2 = ')';
    private static final char LIST_SEPARATOR = ',';
    private static final char LIST_SEPARATOR_2 = '|';
    private static final char RANGE_SEPARATOR = '-';
    private static final ShorthandParser[] PARSERS;

    abstract Iterator<String> extract(String var1) throws IllegalArgumentException;

    public static Set<String> expandShorthand(String s) {
        HashSet<String> results = new HashSet<String>();
        results.add(s);
        HashSet<String> workSet = new HashSet<String>();
        while (true) {
            boolean work = false;
            for (String string : results) {
                Set<String> expanded = ShorthandParser.matchGroup(string);
                if (expanded != null) {
                    work = true;
                    workSet.addAll(expanded);
                    continue;
                }
                workSet.add(string);
            }
            if (!work) break;
            HashSet<String> temp = results;
            results = workSet;
            workSet = temp;
            workSet.clear();
        }
        results.remove(s);
        return results;
    }

    private static Set<String> matchGroup(String input) {
        int openingIndex = ShorthandParser.indexOfEither(input, '{', '(');
        if (openingIndex == -1) {
            return null;
        }
        int closingIndex = ShorthandParser.indexOfEither(input, '}', ')');
        if (closingIndex < openingIndex) {
            return null;
        }
        String before = input.substring(0, openingIndex);
        String after = input.substring(closingIndex + 1);
        String between = input.substring(openingIndex + 1, closingIndex);
        HashSet<String> results = new HashSet<String>();
        for (ShorthandParser parser : PARSERS) {
            try {
                Iterator<String> extracted = parser.extract(between);
                if (extracted == null) continue;
                while (extracted.hasNext()) {
                    results.add(before + extracted.next() + after);
                }
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return results;
    }

    private static int indexOfEither(String s, char c1, char c2) {
        int index = s.indexOf(c1);
        if (index != -1) {
            return index;
        }
        return s.indexOf(c2);
    }

    static {
        PARSERS = ShorthandParser.values();
    }

    private static abstract class RangeIterator
    implements Iterator<String> {
        private final int max;
        private int next;

        RangeIterator(int a, int b) {
            this.max = Math.max(a, b);
            this.next = Math.min(a, b);
        }

        protected abstract String toString(int var1);

        @Override
        public final boolean hasNext() {
            return this.next <= this.max;
        }

        @Override
        public final String next() {
            return this.toString(this.next++);
        }
    }
}

