/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api6;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.context.QueryOptionsSupplier;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.ProxiedServiceObject;
import me.lucko.luckperms.sponge.service.model.ProxiedSubject;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectDataProxy;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;

public final class SubjectProxy
implements Subject,
ProxiedSubject,
ProxiedServiceObject {
    private final LPPermissionService service;
    private final LPSubjectReference ref;
    private QueryOptionsSupplier queryOptionsSupplier = null;

    public SubjectProxy(LPPermissionService service, LPSubjectReference ref) {
        this.service = service;
        this.ref = ref;
    }

    private CompletableFuture<LPSubject> handle() {
        return this.ref.resolveLp();
    }

    private QueryOptionsSupplier getContextsCache() {
        if (this.queryOptionsSupplier == null) {
            this.queryOptionsSupplier = this.service.getContextManager().getCacheFor(this);
        }
        return this.queryOptionsSupplier;
    }

    @Override
    public @NonNull LPSubjectReference asSubjectReference() {
        return this.ref;
    }

    @Override
    public @NonNull QueryOptions getQueryOptions() {
        return this.getContextsCache().getQueryOptions();
    }

    public @NonNull Optional<CommandSource> getCommandSource() {
        return (Optional)((CompletableFuture)this.handle().thenApply(LPSubject::getCommandSource)).join();
    }

    public @NonNull SubjectCollection getContainingCollection() {
        return this.service.getCollection(this.ref.getCollectionIdentifier()).sponge();
    }

    public SubjectData getSubjectData() {
        return new SubjectDataProxy(this.service, this.ref, true);
    }

    public SubjectData getTransientSubjectData() {
        return new SubjectDataProxy(this.service, this.ref, false);
    }

    public boolean hasPermission(@NonNull Set<Context> contexts, @NonNull String permission) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissionValue(CompatibilityUtil.convertContexts(contexts), permission).asBoolean())).join();
    }

    public boolean hasPermission(@NonNull String permission) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissionValue(this.getContextsCache().getContextSet(), permission).asBoolean())).join();
    }

    public @NonNull Tristate getPermissionValue(@NonNull Set<Context> contexts, @NonNull String permission) {
        return (Tristate)((CompletableFuture)this.handle().thenApply(handle -> CompatibilityUtil.convertTristate(handle.getPermissionValue(CompatibilityUtil.convertContexts(contexts), permission)))).join();
    }

    public boolean isChildOf(@NonNull Subject parent) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.isChildOf(this.getContextsCache().getContextSet(), this.service.getReferenceFactory().obtain(parent)))).join();
    }

    public boolean isChildOf(@NonNull Set<Context> contexts, @NonNull Subject parent) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.isChildOf(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(parent)))).join();
    }

    public @NonNull List<Subject> getParents() {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(this.getContextsCache().getContextSet()).stream().map(s -> new SubjectProxy(this.service, (LPSubjectReference)s)).collect(ImmutableCollectors.toList()))).join();
    }

    public @NonNull List<Subject> getParents(@NonNull Set<Context> contexts) {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(CompatibilityUtil.convertContexts(contexts)).stream().map(s -> new SubjectProxy(this.service, (LPSubjectReference)s)).collect(ImmutableCollectors.toList()))).join();
    }

    public @NonNull Optional<String> getOption(@NonNull Set<Context> contexts, @NonNull String key) {
        return (Optional)((CompletableFuture)this.handle().thenApply(handle -> handle.getOption(CompatibilityUtil.convertContexts(contexts), key))).join();
    }

    public @NonNull Optional<String> getOption(@NonNull String key) {
        return (Optional)((CompletableFuture)this.handle().thenApply(handle -> handle.getOption(this.getContextsCache().getContextSet(), key))).join();
    }

    public String getIdentifier() {
        return this.ref.getSubjectIdentifier();
    }

    public @NonNull Set<Context> getActiveContexts() {
        return CompatibilityUtil.convertContexts(this.getContextsCache().getContextSet());
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SubjectProxy && this.ref.equals(((SubjectProxy)o).ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return "luckperms.api6.SubjectProxy(ref=" + this.ref + ")";
    }
}

