/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api;

import net.luckperms.api.LuckPerms;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.ApiStatus;

public final class LuckPermsProvider {
    private static LuckPerms instance = null;

    public static @NonNull LuckPerms get() {
        if (instance == null) {
            throw new NotLoadedException();
        }
        return instance;
    }

    @ApiStatus.Internal
    static void register(LuckPerms instance) {
        LuckPermsProvider.instance = instance;
    }

    @ApiStatus.Internal
    static void unregister() {
        instance = null;
    }

    @ApiStatus.Internal
    private LuckPermsProvider() {
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }

    private static final class NotLoadedException
    extends IllegalStateException {
        private static final String MESSAGE = "The LuckPerms API isn't loaded yet!\nThis could be because:\n  a) the LuckPerms plugin is not installed or it failed to enable\n  b) your plugin does not declare a dependency on LuckPerms\n  c) you are attempting to use the API before plugins reach the 'enable' phase\n     (call the #get method in onEnable, not in your plugin constructor!)\n";

        NotLoadedException() {
            super(MESSAGE);
        }
    }
}

