/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mtlib.utils;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapModification;
import java.util.Map;

public abstract class BaseMapRemoval<K, V>
extends BaseMapModification<K, V> {
    protected BaseMapRemoval(String name, Map<K, V> map) {
        super(name, map);
    }

    protected BaseMapRemoval(String name, Map<K, V> map, Map<K, V> recipes) {
        this(name, map);
        if (recipes != null) {
            this.recipes.putAll(recipes);
        }
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Object key : this.recipes.keySet()) {
            Object oldValue = this.map.remove(key);
            if (oldValue != null) {
                this.successful.put(key, oldValue);
                continue;
            }
            LogHelper.logError(String.format("Error removing %s Recipe : null object", this.name));
        }
    }

    @Override
    public String describe() {
        return String.format("Removing %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

