/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulevs.betternether.BetterNether;

public class BlockNetherReed
extends Block {
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);

    public BlockNetherReed() {
        super(Material.field_151585_k, MapColor.field_151679_y);
        this.func_149663_c("nether_reed");
        this.func_149672_a(SoundType.field_185850_c);
        this.setRegistryName("nether_reed");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)((Object)EnumShape.TOP)));
        this.func_149675_a(true);
        this.func_149647_a(BetterNether.BN_TAB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == this) {
            return true;
        }
        if (!(block instanceof BlockNetherrack) && block != Blocks.field_150425_aM) {
            return false;
        }
        BlockPos blockpos = pos.func_177977_b();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177972_a(enumfacing));
            if (iblockstate.func_185904_a() != Material.field_151587_i) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return this.func_176196_c(worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this || this.checkForDrop(worldIn, pos, state)) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (rand.nextInt(16) == 0) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.func_176196_c(worldIn, pos)) {
            worldIn.func_180501_a(pos, state, 2);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this ? state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.BOTTOM)) : state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.TOP));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumShape implements IStringSerializable
    {
        TOP(0, "top"),
        BOTTOM(1, "bottom");

        private final String name;
        private final int index;

        private EnumShape(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

