/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.access;

import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class AccessCommand
extends AbstractCommand {
    public AccessCommand(EagleFactionsPlugin plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(player.getWorld().getUniqueId(), player.getLocation().getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            throw new CommandException(PluginInfo.ERROR_PREFIX.concat((Text)Text.of((String)Messages.THIS_PLACE_DOES_NOT_BELONG_TO_ANYONE)));
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (!playerFaction.getName().equals(chunkFaction.getName())) {
            throw new CommandException(PluginInfo.ERROR_PREFIX.concat((Text)Text.of((String)Messages.THIS_PLACE_DOES_NOT_BELONG_TO_YOUR_FACTION)));
        }
        if (!(playerFaction.getLeader().equals(player.getUniqueId()) || playerFaction.getOfficers().contains(player.getUniqueId()) || super.getPlugin().getPlayerManager().hasAdminMode((User)player))) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS}));
        }
        Optional<Claim> optionalClaim = chunkFaction.getClaimAt(player.getWorld().getUniqueId(), player.getLocation().getChunkPosition());
        Claim claim = optionalClaim.get();
        return this.showAccess(player, claim);
    }

    private CommandResult showAccess(Player player, Claim claim) {
        Text claimLocation = Text.of((Object[])new Object[]{TextColors.AQUA, "Location: ", TextColors.GOLD, claim.getChunkPosition()});
        Text text = Text.of((Object[])new Object[]{TextColors.AQUA, "Accessible by faction: ", TextColors.GOLD, claim.isAccessibleByFaction()});
        List ownersNames = claim.getOwners().stream().map(owner -> super.getPlugin().getPlayerManager().getFactionPlayer((UUID)owner)).filter(Optional::isPresent).map(factionPlayer -> ((FactionPlayer)factionPlayer.get()).getName()).collect(Collectors.toList());
        Text text1 = Text.of((Object[])new Object[]{TextColors.AQUA, "Owners: ", TextColors.GOLD, String.join((CharSequence)", ", ownersNames)});
        ArrayList<Text> contents = new ArrayList<Text>();
        contents.add(claimLocation);
        contents.add(text);
        contents.add(text1);
        PaginationList paginationList = PaginationList.builder().contents(contents).padding((Text)Text.of((String)"=")).title(Text.of((Object[])new Object[]{TextColors.GREEN, "Claim Access"})).build();
        paginationList.sendTo((MessageReceiver)player);
        return CommandResult.success();
    }
}

