/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.admin;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class RegenCommand
extends AbstractCommand {
    public RegenCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        UUID uuid;
        Faction factionToRegen = (Faction)context.requireOne("faction");
        if (factionToRegen.isSafeZone() || factionToRegen.isWarZone()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_FACTION_CANNOT_BE_DISBANDED}));
        }
        UUID uUID = uuid = source instanceof Player ? ((Player)source).getUniqueId() : UUID.fromString(source.getName());
        if (!EagleFactionsPlugin.REGEN_CONFIRMATION_MAP.containsKey(uuid) || !EagleFactionsPlugin.REGEN_CONFIRMATION_MAP.get(uuid).equals(factionToRegen.getName())) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.YELLOW, Messages.REGEN_WARNING_CONFIRMATION_REQUIRED}));
            EagleFactionsPlugin.REGEN_CONFIRMATION_MAP.put(uuid, factionToRegen.getName());
            return CommandResult.success();
        }
        EagleFactionsPlugin.REGEN_CONFIRMATION_MAP.remove(uuid);
        boolean didSucceed = super.getPlugin().getFactionLogic().disbandFaction(factionToRegen.getName());
        if (didSucceed) {
            if (source instanceof Player) {
                Player player = (Player)source;
                EagleFactionsPlugin.AUTO_CLAIM_LIST.remove(player.getUniqueId());
                EagleFactionsPlugin.CHAT_LIST.remove(player.getUniqueId());
            }
        } else {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.SOMETHING_WENT_WRONG}));
        }
        for (Claim claim : factionToRegen.getClaims()) {
            Optional world = Sponge.getServer().getWorld(claim.getWorldUUID());
            if (!world.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.SOMETHING_WENT_WRONG}));
            }
            ((World)world.get()).regenerateChunk(claim.getChunkPosition());
        }
        source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.WHITE, Messages.FACTION_HAS_BEEN_REGENERATED}));
        return CommandResult.success();
    }
}

