/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.args;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class FactionPlayerArgument
extends CommandElement {
    private final EagleFactions plugin;

    public FactionPlayerArgument(EagleFactions plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected FactionPlayer parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        HashSet<FactionPlayer> serverPlayers = new HashSet<FactionPlayer>(FactionsCache.getPlayersMap().values());
        if (args.hasNext()) {
            String argument = args.next();
            for (FactionPlayer player : serverPlayers) {
                if (!player.getName().equals(argument)) continue;
                return player;
            }
            throw args.createError((Text)Text.of((String)"Argument is not a valid player!"));
        }
        throw args.createError((Text)Text.of((String)"Argument is not a valid player!"));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Map<UUID, FactionPlayer> factionPlayerMap = FactionsCache.getPlayersMap();
        ArrayList<FactionPlayer> list = new ArrayList<FactionPlayer>(factionPlayerMap.values());
        if (args.hasNext()) {
            String charSequence = (String)args.nextIfPresent().get();
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                FactionPlayer factionPlayer = (FactionPlayer)list.get(i);
                String factionPlayerName = factionPlayer.getName();
                if (!factionPlayerName.toLowerCase().startsWith(charSequence.toLowerCase())) continue;
                resultList.add(factionPlayerName);
            }
            return resultList;
        }
        return list.stream().map(FactionPlayer::getName).collect(Collectors.toList());
    }
}

