/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.backup;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class RestoreBackupCommand
extends AbstractCommand {
    public RestoreBackupCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        String filename = (String)context.requireOne((Text)Text.of((String)"filename"));
        CompletableFuture.runAsync(() -> {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, "Restoring backup ", TextColors.GOLD, filename}));
            boolean result = super.getPlugin().getStorageManager().restoreBackup(filename);
            if (result) {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, "Backup has been successfully restored!"}));
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, "Could not restore the backup. Check your server log file for more details."}));
            }
        });
        return CommandResult.success();
    }
}

