/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.general;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

public class ListCommand
extends AbstractCommand {
    public ListCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        CompletableFuture.runAsync(() -> {
            Collection<Faction> factionsList = super.getPlugin().getFactionLogic().getFactions().values();
            ArrayList<Text> helpList = new ArrayList<Text>();
            Text tagPrefix = this.getPlugin().getConfiguration().getChatConfig().getFactionStartPrefix();
            Text tagSuffix = this.getPlugin().getConfiguration().getChatConfig().getFactionEndPrefix();
            for (Faction faction : factionsList) {
                Text tag = Text.builder().append(new Text[]{tagPrefix}).append(new Text[]{faction.getTag()}).append(new Text[]{tagSuffix, Text.of((String)" ")}).build();
                Text factionHelp = Text.builder().append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "- "})}).append(new Text[]{tag}).append(new Text[]{Text.of((Object[])new Object[]{faction.getName(), " (", Float.valueOf(this.getPlugin().getPowerManager().getFactionPower(faction)), "/", Float.valueOf(this.getPlugin().getPowerManager().getFactionMaxPower(faction)), ")"})}).build()}).onClick((ClickAction)TextActions.runCommand((String)("/f info " + faction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextStyles.ITALIC, TextColors.BLUE, "Click", TextColors.RESET, " for more info..."}))).build();
                helpList.add(factionHelp);
            }
            PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
            PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.FACTIONS_LIST})).padding((Text)Text.of((String)"-")).contents(helpList);
            paginationBuilder.sendTo((MessageReceiver)source);
        });
        return CommandResult.success();
    }
}

