/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.util.Identifiable;

public class PlayerManagerImpl
implements PlayerManager {
    private final StorageManager storageManager;
    private final FactionLogic factionLogic;
    private final FactionsConfig factionsConfig;
    private final PowerConfig powerConfig;
    private UserStorageService userStorageService;

    public PlayerManagerImpl(StorageManager storageManager, FactionLogic factionLogic, FactionsConfig factionsConfig, PowerConfig powerConfig) {
        this.storageManager = storageManager;
        this.factionLogic = factionLogic;
        this.factionsConfig = factionsConfig;
        this.powerConfig = powerConfig;
        Optional optionalUserStorageService = Sponge.getServiceManager().provide(UserStorageService.class);
        optionalUserStorageService.ifPresent(x -> {
            this.userStorageService = x;
        });
    }

    @Override
    public boolean addPlayer(UUID playerUUID, String playerName) {
        FactionPlayerImpl factionPlayer = new FactionPlayerImpl(playerName, playerUUID, null, this.powerConfig.getStartingPower(), this.powerConfig.getGlobalMaxPower(), null, false);
        return this.storageManager.savePlayer(factionPlayer);
    }

    @Override
    public boolean savePlayer(FactionPlayer factionPlayer) {
        return this.storageManager.savePlayer(factionPlayer);
    }

    @Override
    public Optional<FactionPlayer> getFactionPlayer(UUID playerUUID) {
        FactionPlayer factionPlayer = this.storageManager.getPlayer(playerUUID);
        if (factionPlayer == null) {
            return Optional.empty();
        }
        return Optional.of(factionPlayer);
    }

    @Override
    public Optional<Player> getPlayer(UUID playerUUID) {
        Optional<User> oUser = this.getUser(playerUUID);
        return oUser.flatMap(User::getPlayer);
    }

    @Override
    public boolean isPlayerOnline(UUID playerUUID) {
        Optional<User> oUser = this.getUser(playerUUID);
        return oUser.map(User::isOnline).orElse(false);
    }

    @Override
    public Set<String> getServerPlayerNames() {
        return this.storageManager.getServerPlayerNames();
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        return this.storageManager.getServerPlayers();
    }

    private Optional<User> getUser(UUID playerUUID) {
        return this.userStorageService.get(playerUUID);
    }

    @Override
    public boolean hasAdminMode(User player) {
        return player.hasPermission("eaglefactions.admin.adminmode");
    }

    @Override
    public Set<UUID> getAdminModePlayers() {
        return Sponge.getServer().getOnlinePlayers().stream().filter(this::hasAdminMode).map(Identifiable::getUniqueId).collect(Collectors.toSet());
    }

    @Override
    public void setDeathInWarZone(UUID playerUUID, boolean didDie) {
        FactionPlayer factionPlayer = this.storageManager.getPlayer(playerUUID);
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), factionPlayer.getFactionName().orElse(null), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.getFactionRole(), didDie);
        this.storageManager.savePlayer(updatedPlayer);
    }
}

