/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.scheduling;

import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.managers.PowerManager;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsConsumerTask;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.scheduler.Task;

public class PowerIncrementTask
implements EagleFactionsConsumerTask<Task> {
    private final PlayerManager playerManager;
    private final PowerManager powerManager;
    private final PowerConfig powerConfig;
    private final UUID playerUUID;

    public PowerIncrementTask(PlayerManager playerManager, PowerManager powerManager, PowerConfig powerConfig, UUID playerUUID) {
        this.playerManager = playerManager;
        this.powerManager = powerManager;
        this.powerConfig = powerConfig;
        this.playerUUID = playerUUID;
    }

    @Override
    public void accept(Task task) {
        Optional<FactionPlayer> optionalFactionPlayer;
        if (!this.playerManager.isPlayerOnline(this.playerUUID)) {
            task.cancel();
        }
        if (!(optionalFactionPlayer = this.playerManager.getFactionPlayer(this.playerUUID)).isPresent()) {
            return;
        }
        FactionPlayer factionPlayer = optionalFactionPlayer.get();
        if (factionPlayer.getPower() + this.powerConfig.getPowerIncrement() < factionPlayer.getMaxPower()) {
            this.powerManager.addPower(this.playerUUID, false);
        } else {
            this.powerManager.setPlayerPower(this.playerUUID, factionPlayer.getMaxPower());
        }
    }
}

