/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.serializers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;

public class InventorySerializer {
    static final DataQuery SLOT = DataQuery.of((String[])new String[]{"slot"});
    static final DataQuery STACK = DataQuery.of((String[])new String[]{"stack"});

    public static List<DataView> serializeInventory(Inventory inventory) {
        LinkedList<DataView> slots = new LinkedList<DataView>();
        int i = 0;
        for (Inventory inv : inventory.slots()) {
            Optional stack = inv.peek();
            if (stack.isPresent()) {
                DataContainer container = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.ALL_DATA_CLONED);
                container.set(SLOT, (Object)i);
                container.set(STACK, (Object)InventorySerializer.serializeItemStack((ItemStack)stack.get()));
                slots.add((DataView)container);
            }
            ++i;
        }
        return slots;
    }

    public static boolean deserializeInventory(List<DataView> slots, Inventory inventory) {
        int i;
        HashMap<Integer, ItemStack> stacks = new HashMap<Integer, ItemStack>();
        boolean fail = false;
        for (DataView slot : slots) {
            i = (Integer)slot.getInt(SLOT).get();
            ItemStack stack = InventorySerializer.deserializeItemStack((DataView)slot.getView(STACK).get());
            stacks.put(i, stack);
        }
        i = 0;
        for (DataView slot : inventory.slots()) {
            if (stacks.containsKey(i)) {
                try {
                    slot.set((ItemStack)stacks.get(i));
                }
                catch (NoSuchElementException e) {
                    slot.clear();
                    fail = true;
                }
            } else {
                slot.clear();
            }
            ++i;
        }
        return fail;
    }

    public static DataView serializeItemStack(ItemStack item) {
        return item.toContainer();
    }

    public static ItemStack deserializeItemStack(DataView data) {
        return ItemStack.builder().fromContainer(data).build();
    }
}

