/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public abstract class AbstractPlayerStorage
implements PlayerStorage {
    private static final String INSERT_PLAYER = "INSERT INTO Players (PlayerUUID, Name, Faction, Power, MaxPower, DeathInWarzone) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_PLAYER = "UPDATE Players SET PlayerUUID = ?, Name = ?, Faction = ?, Power = ?, MaxPower = ?, DeathInWarzone = ? WHERE PlayerUUID = ?";
    private static final String SELECT_PLAYERS = "SELECT * FROM Players";
    private static final String SELECT_PLAYER_NAMES = "SELECT Name FROM Players";
    private static final String SELECT_PLAYER_WHERE_UUID = "SELECT * FROM Players WHERE PlayerUUID=? LIMIT 1";
    private static final String DELETE_PLAYERS = "DELETE FROM Players";
    private final EagleFactions plugin;
    private final SQLProvider sqlProvider;

    protected AbstractPlayerStorage(EagleFactions plugin, SQLProvider sqlProvider) {
        if (sqlProvider == null) {
            Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not establish connection to the database. Aborting..."}));
            Sponge.getServer().shutdown();
        }
        this.plugin = plugin;
        this.sqlProvider = sqlProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FactionPlayer getPlayer(UUID playerUUID) {
        FactionPlayerImpl factionPlayer = null;
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement statement = connection.prepareStatement(SELECT_PLAYER_WHERE_UUID);
            statement.setString(1, playerUUID.toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.first()) {
                String name = resultSet.getString("Name");
                String factionName = resultSet.getString("Faction");
                float power = resultSet.getFloat("Power");
                float maxpower = resultSet.getFloat("MaxPower");
                boolean deathInWarzone = resultSet.getBoolean("DeathInWarzone");
                factionPlayer = new FactionPlayerImpl(name, playerUUID, factionName, power, maxpower, null, deathInWarzone);
            }
            resultSet.close();
            statement.close();
            FactionPlayerImpl factionPlayerImpl = factionPlayer;
            return factionPlayerImpl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean savePlayer(FactionPlayer player) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_PLAYER_WHERE_UUID);
            preparedStatement.setString(1, player.getUniqueId().toString());
            ResultSet factionSelect = preparedStatement.executeQuery();
            boolean exists = factionSelect.next();
            preparedStatement.close();
            String queryToUse = exists ? UPDATE_PLAYER : INSERT_PLAYER;
            PreparedStatement statement = connection.prepareStatement(queryToUse);
            statement.setString(1, player.getUniqueId().toString());
            statement.setString(2, player.getName());
            statement.setString(3, player.getFactionName().orElse(null));
            statement.setFloat(4, player.getPower());
            statement.setFloat(5, player.getMaxPower());
            statement.setBoolean(6, player.diedInWarZone());
            if (exists) {
                statement.setString(7, player.getUniqueId().toString());
            }
            boolean didSucceed = statement.execute();
            statement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean savePlayers(List<FactionPlayer> players) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement statement = connection.prepareStatement(INSERT_PLAYER);
            for (FactionPlayer player : players) {
                statement.setString(1, player.getUniqueId().toString());
                statement.setString(2, player.getName());
                statement.setString(3, player.getFactionName().orElse(null));
                statement.setFloat(4, player.getPower());
                statement.setFloat(5, player.getMaxPower());
                statement.setBoolean(6, player.diedInWarZone());
                statement.addBatch();
            }
            int[] results = statement.executeBatch();
            statement.close();
            boolean bl = results.length > 0;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Set<String> getServerPlayerNames() {
        HashSet<String> playerNames = new HashSet<String>();
        try (Connection connection = this.sqlProvider.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(SELECT_PLAYER_NAMES);
            while (resultSet.next()) {
                String playerName = resultSet.getString("Name");
                playerNames.add(playerName);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerNames;
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        HashSet<FactionPlayer> factionPlayers = new HashSet<FactionPlayer>();
        try (Connection connection = this.sqlProvider.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(SELECT_PLAYERS);
            while (resultSet.next()) {
                UUID playerUUID = UUID.fromString(resultSet.getString("PlayerUUID"));
                String name = resultSet.getString("Name");
                String factionName = resultSet.getString("Faction");
                float power = resultSet.getFloat("Power");
                float maxpower = resultSet.getFloat("MaxPower");
                boolean deathInWarzone = resultSet.getBoolean("DeathInWarzone");
                FactionPlayerImpl factionPlayer = new FactionPlayerImpl(name, playerUUID, factionName, power, maxpower, null, deathInWarzone);
                factionPlayers.add(factionPlayer);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return factionPlayers;
    }

    @Override
    public void deletePlayers() {
        try (Connection connection = this.sqlProvider.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute(DELETE_PLAYERS);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

