/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.audio;

import cofh.core.audio.ISoundSource;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class SoundTile
extends PositionedSound
implements ITickableSound {
    ISoundSource source;
    boolean beginFadeOut;
    boolean donePlaying;
    int ticks = 0;
    int fadeIn = 50;
    int fadeOut = 50;
    float baseVolume = 1.0f;

    public SoundTile(ISoundSource source, SoundEvent sound, float volume, float pitch, boolean repeat, int repeatDelay, Vec3d pos) {
        this(source, sound, volume, pitch, repeat, repeatDelay, pos, ISound.AttenuationType.LINEAR);
    }

    public SoundTile(ISoundSource source, SoundEvent sound, float volume, float pitch, boolean repeat, int repeatDelay, Vec3d pos, ISound.AttenuationType attenuation) {
        super(sound, SoundCategory.AMBIENT);
        this.field_147660_d = (float)pos.field_72450_a;
        this.field_147661_e = (float)pos.field_72448_b;
        this.field_147658_f = (float)pos.field_72449_c;
        this.field_147662_b = volume;
        this.field_147663_c = pitch;
        this.field_147659_g = repeat;
        this.field_147665_h = repeatDelay;
        this.field_147666_i = attenuation;
        this.source = source;
        this.baseVolume = volume;
    }

    public SoundTile setFadeIn(int fadeIn) {
        this.fadeIn = Math.min(0, fadeIn);
        return this;
    }

    public SoundTile setFadeOut(int fadeOut) {
        this.fadeOut = Math.min(0, fadeOut);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void func_73660_a() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.source.shouldPlaySound()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.field_147662_b = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }
}

