/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.data.Tasks;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;

public class ChunkCache
implements IFileProvider,
IHeightMap {
    Cache<Integer, int[]> cachedHeights = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    Deque<ITask> tasks = new ConcurrentLinkedDeque<ITask>();
    int[] dataIndexes = new int[4000000];
    int currentIndex = 0;
    RandomAccessFile chunkData;
    RandomAccessFile heightData;
    File chunkFile;
    File heightFile;

    public ChunkCache(File chunk, File height) throws Exception {
        this.chunkFile = chunk;
        this.heightFile = height;
        this.chunkData = new RandomAccessFile(chunk, "rw");
        this.heightData = new RandomAccessFile(height, "rw");
        Arrays.fill(this.dataIndexes, -1);
    }

    public boolean reset() {
        while (!this.tasks.isEmpty()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        this.close();
        try {
            this.deleteSave(this.chunkFile);
            this.deleteSave(this.heightFile);
            this.chunkData = new RandomAccessFile(this.chunkFile, "rw");
            this.heightData = new RandomAccessFile(this.heightFile, "rw");
            Arrays.fill(this.dataIndexes, -1);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void deleteSave(File file) {
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.chunkData != null) {
                this.chunkData.close();
                this.chunkData = null;
            }
            if (this.heightData != null) {
                this.heightData.close();
                this.heightData = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update() {
        try {
            while (!this.tasks.isEmpty()) {
                this.tasks.removeFirst().handleTask(this.chunkData, this.heightData, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTask(ITask task) {
        this.tasks.add(task);
    }

    public IChunkData getChunk(int x, int z, Cache<FilePos, IChunkData> cache) {
        Tasks.FetchChunkTask data = new Tasks.FetchChunkTask(x, z, cache);
        this.addTask(data);
        int tries = 0;
        while (!data.isDone()) {
            if (++tries >= 5) {
                return null;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        return data.getData();
    }

    @Override
    public boolean hasIndex(int x, int y) {
        int index = this.index(x, y);
        return index < 0 || index >= 4000000 ? false : this.dataIndexes[index] != -1;
    }

    @Override
    public long getIndex(int x, int y, IFileProvider.FileType type) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return -1L;
        }
        return (long)this.dataIndexes[index] * type.getOffset();
    }

    @Override
    public long getOrCreateIndex(int x, int y, IFileProvider.FileType type) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return -1L;
        }
        if (this.dataIndexes[index] == -1) {
            this.dataIndexes[index] = this.currentIndex++;
        }
        return (long)this.dataIndexes[index] * type.getOffset();
    }

    @Override
    public long getTotalOffset(IFileProvider.FileType type) {
        return (long)this.currentIndex * type.getOffset();
    }

    @Override
    public int getStored() {
        return this.currentIndex;
    }

    private int index(int x, int y) {
        return (y + 1000) * 2000 + (x + 1000);
    }

    @Override
    public void storeHeightData(int x, int y, int[] heights) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return;
        }
        this.cachedHeights.put((Object)index, (Object)heights);
    }

    @Override
    public int getHeight(int x, int y) {
        return this.getHeight(x, y, 0);
    }

    @Override
    public int getHeight(int x, int y, int defaultValue) {
        int[] height = this.getHeightData(x >> 4, y >> 4);
        if (height.length <= 0) {
            return defaultValue;
        }
        return height[(y & 0xF) * 16 + (x & 0xF)];
    }

    @Override
    public int[] getHeightData(int x, int y) {
        if (!this.hasHeightsStored(x, y)) {
            return new int[0];
        }
        int index = this.index(x, y);
        int[] data = (int[])this.cachedHeights.getIfPresent((Object)index);
        if (data == null) {
            data = this.loadDataFromDisk(x, y);
            this.cachedHeights.put((Object)index, (Object)data);
        }
        return data;
    }

    @Override
    public boolean hasHeightsStored(int x, int y) {
        return this.getIndex(x, y, IFileProvider.FileType.HeightData) >= 0L;
    }

    private int[] loadDataFromDisk(int x, int y) {
        Tasks.FetchHeightData data = new Tasks.FetchHeightData(x, y);
        this.addTask(data);
        while (!data.isDone()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return new int[256];
            }
        }
        return data.getHeightData();
    }
}

