/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.senders;

import io.netty.channel.Channel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;
import openmods.utils.NetUtils;

public class TargetedPacketSenderBase<T>
implements ITargetedPacketSender<T> {
    private final Channel channel;

    public TargetedPacketSenderBase(Channel channel) {
        this.channel = channel;
    }

    protected void configureChannel(Channel channel, T target) {
    }

    protected void cleanupChannel(Channel channel) {
    }

    @Override
    public void sendMessage(Object msg, T target) {
        this.configureChannel(this.channel, target);
        this.channel.writeAndFlush(msg).addListener((GenericFutureListener)NetUtils.LOGGING_LISTENER);
        this.cleanupChannel(this.channel);
    }

    @Override
    public void sendMessages(Collection<Object> msgs, T target) {
        this.configureChannel(this.channel, target);
        for (Object msg : msgs) {
            this.channel.write(msg).addListener((GenericFutureListener)NetUtils.LOGGING_LISTENER);
        }
        this.channel.flush();
        this.cleanupChannel(this.channel);
    }

    @Override
    public IPacketSender bind(final T target) {
        return new IPacketSender(){

            @Override
            public void sendMessage(Object msg) {
                TargetedPacketSenderBase.this.sendMessage(msg, target);
            }

            @Override
            public void sendMessages(Collection<Object> msg) {
                TargetedPacketSenderBase.this.sendMessages(msg, target);
            }
        };
    }
}

