/*
 * Decompiled with CFR 0.152.
 */
package openmods.physics;

import openmods.physics.FastVector;

public class Point {
    private FastVector current;
    private FastVector previous;
    private FastVector force;
    double mass;
    double inv_mass;

    public Point(double x, double y, double z) {
        this.current = this.previous = new FastVector(x, y, z);
        this.inv_mass = 1.0;
        this.mass = 1.0;
        this.force = new FastVector(0.0, -0.5, 0.0).multiply(0.0025000000000000005);
    }

    public void setCurrent(FastVector v) {
        this.current = v;
    }

    public void setPrevious(FastVector v) {
        this.previous = v;
    }

    public FastVector getCurrent() {
        return this.current;
    }

    public FastVector getPrevious() {
        return this.previous;
    }

    public void update() {
        if (this.inv_mass != 0.0) {
            FastVector new_pos = this.current.multiply(1.99).subtract(this.previous.multiply(0.99)).add(this.force);
            double d = new_pos.x < 0.0 ? 0.0 : (new_pos.x = new_pos.x > 1.0 ? 1.0 : new_pos.x);
            double d2 = new_pos.y < 0.0 ? 0.0 : (new_pos.y = new_pos.y > 1.0 ? 1.0 : new_pos.y);
            new_pos.z = new_pos.z < 0.0 ? 0.0 : (new_pos.z > 1.0 ? 1.0 : new_pos.z);
            this.previous = this.current;
            this.current = new_pos;
        }
    }
}

