/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import openmods.OpenMods;
import openmods.sync.ISyncMapProvider;
import openmods.sync.SyncMapEntity;
import openmods.sync.SyncMapTile;
import openmods.utils.NetUtils;

@ChannelHandler.Sharable
public class InboundSyncHandler
extends SimpleChannelInboundHandler<FMLProxyPacket> {
    protected void channelRead0(ChannelHandlerContext ctx, final FMLProxyPacket msg) throws Exception {
        NetUtils.executeSynchronized(ctx, new Runnable(){

            @Override
            public void run() {
                PacketBuffer payload = new PacketBuffer(msg.payload());
                ISyncMapProvider provider = this.findSyncMapProvider(payload);
                try {
                    if (provider != null) {
                        provider.getSyncMap().readUpdate(payload);
                    }
                }
                catch (Throwable e) {
                    throw new SyncException(e, provider);
                }
            }

            private ISyncMapProvider findSyncMapProvider(PacketBuffer payload) {
                int ownerType = payload.func_150792_a();
                World world = OpenMods.proxy.getClientWorld();
                switch (ownerType) {
                    case 0: {
                        return SyncMapEntity.findOwner(world, payload);
                    }
                    case 1: {
                        return SyncMapTile.findOwner(world, payload);
                    }
                }
                throw new IllegalArgumentException("Unknown sync map owner type: " + ownerType);
            }
        });
    }

    public static class SyncException
    extends RuntimeException {
        private static final long serialVersionUID = 2585053869917082095L;

        public SyncException(Throwable cause, ISyncMapProvider provider) {
            super(String.format("Failed to sync %s (%s)", provider, provider.getClass()), cause);
        }
    }
}

