/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.key;

import me.lucko.luckperms.lib.adventure.key.KeyImpl;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Key
extends Comparable<Key> {
    public static final String MINECRAFT_NAMESPACE = "minecraft";

    public static @NonNull Key key(@NonNull String string) {
        return Key.key(string, ':');
    }

    public static @NonNull Key key(@NonNull String string, char character) {
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.key(namespace, value);
    }

    public static @NonNull Key key(@NonNull String namespace, @NonNull String value) {
        return new KeyImpl(namespace, value);
    }

    public @NonNull String namespace();

    public @NonNull String value();

    public @NonNull String asString();

    @Override
    default public int compareTo(@NonNull Key that) {
        int value = this.value().compareTo(that.value());
        if (value != 0) {
            return KeyImpl.clampCompare(value);
        }
        return KeyImpl.clampCompare(this.namespace().compareTo(that.namespace()));
    }
}

