/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import me.lucko.luckperms.lib.adventure.nbt.FloatBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ShadyPines;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FloatBinaryTagImpl
implements FloatBinaryTag {
    private final float value;

    FloatBinaryTagImpl(float value) {
        this.value = value;
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(ShadyPines.floor(this.value) & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return ShadyPines.floor(this.value);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public short shortValue() {
        return (short)(ShadyPines.floor(this.value) & 0xFFFF);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FloatBinaryTagImpl that = (FloatBinaryTagImpl)other;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(that.value);
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public @NonNull String toString() {
        return "FloatBinaryTagImpl{value=" + this.value + '}';
    }
}

