/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.PatternReplacementResult;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.TextReplacementRenderer;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.util.IntFunction2;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractComponent
implements Component {
    protected final List<Component> children;
    protected final Style style;

    static List<Component> asComponents(List<? extends ComponentLike> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(list.size());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ComponentLike like = list.get(i);
            Component component = like.asComponent();
            if (component == Component.empty()) continue;
            components.add(component);
        }
        return Collections.unmodifiableList(components);
    }

    static <T> List<T> addOne(List<T> oldList, T newElement) {
        if (oldList.isEmpty()) {
            return Collections.singletonList(newElement);
        }
        ArrayList<T> newList = new ArrayList<T>(oldList.size() + 1);
        newList.addAll(oldList);
        newList.add(newElement);
        return newList;
    }

    protected AbstractComponent(@NonNull List<? extends ComponentLike> children, @NonNull Style style) {
        this.children = AbstractComponent.asComponents(children);
        this.style = style;
    }

    @Override
    public final @NonNull List<Component> children() {
        return this.children;
    }

    @Override
    public final @NonNull Style style() {
        return this.style;
    }

    @Override
    public @NonNull Component replaceText(@NonNull Pattern pattern, @NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement, @NonNull IntFunction2<PatternReplacementResult> fn) {
        return TextReplacementRenderer.INSTANCE.render((Component)this, new TextReplacementRenderer.State(pattern, (result, builder) -> (ComponentLike)replacement.apply((TextComponent.Builder)builder), fn));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractComponent)) {
            return false;
        }
        AbstractComponent that = (AbstractComponent)other;
        return Objects.equals(this.children, that.children) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        int result = this.children.hashCode();
        result = 31 * result + this.style.hashCode();
        return result;
    }

    public @NonNull String toString() {
        return "AbstractComponent{children=" + this.children + ", style=" + this.style + '}';
    }
}

