/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tileentity.TileEntity;
import omtteam.omlib.api.permission.ITrustedPlayersManager;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public class TrustedPlayersManagerGlobal
implements ITrustedPlayersManager {
    protected List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    Player owner;

    public TrustedPlayersManagerGlobal(Player owner) {
        this.owner = owner;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean addTrustedPlayer(String name) {
        Player player = PlayerUtil.getPlayerFromUsernameCache(name);
        if (player == null && GeneralUtil.isServerInOnlineMode()) {
            DebugHandler.getInstance().sendMessageToDebugChat("Did not find player named " + name + "in the username cache.");
            return false;
        }
        if (player == null) {
            DebugHandler.getInstance().sendMessageToDebugChat("Invalid player!");
            return false;
        }
        TrustedPlayer trustedPlayer = new TrustedPlayer(player.getName());
        trustedPlayer.setUuid(player.getUuid());
        if (trustedPlayer.getUuid() != null || !GeneralUtil.isServerInOnlineMode()) {
            for (TrustedPlayer existPlayer : this.trustedPlayers) {
                if (!GeneralUtil.isServerInOnlineMode()) {
                    if (!existPlayer.getName().equalsIgnoreCase(name)) continue;
                    DebugHandler.getInstance().sendMessageToDebugChat("Already on trust list!");
                    return false;
                }
                if (!existPlayer.getName().equalsIgnoreCase(name) && !trustedPlayer.getUuid().equals(existPlayer.getUuid())) continue;
                return false;
            }
            DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully added " + name + ".");
            this.trustedPlayers.add(trustedPlayer);
            return true;
        }
        return false;
    }

    @Override
    public List<TrustedPlayer> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    @Override
    public void setTrustedPlayers(List<TrustedPlayer> trustedPlayers) {
        this.trustedPlayers = trustedPlayers;
    }

    @Override
    public boolean useGlobal() {
        return false;
    }

    @Override
    public void setUseGlobal(boolean useGlobal) {
    }

    @Override
    public boolean hasTile() {
        return false;
    }

    @Override
    public TileEntity getTile() {
        return null;
    }
}

