/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.ItemDescription;
import stevekung.mods.moreplanets.utils.blocks.BlockAdvancedTileMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class BlockShieldGenerator
extends BlockAdvancedTileMP
implements IDescription {
    public BlockShieldGenerator(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)MorePlanetsMod.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_176746_e().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShieldGenerator) {
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            shield.onCreate(world, pos);
            if (itemStack.func_77942_o()) {
                NBTTagCompound nbt = itemStack.func_77978_p();
                shield.storage.setEnergyStored(nbt.func_74760_g("EnergyStored"));
                shield.shieldSize = nbt.func_74760_g("ShieldSize");
                shield.maxShieldSize = nbt.func_74762_e("MaxShieldSize");
                shield.shieldDamage = nbt.func_74762_e("ShieldDamage");
                shield.maxShieldDamage = nbt.func_74762_e("MaxShieldDamage");
                shield.shieldCapacity = nbt.func_74762_e("ShieldCapacity");
                shield.maxShieldCapacity = nbt.func_74762_e("MaxShieldCapacity");
                shield.shieldChargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
                shield.needCharged = nbt.func_74767_n("NeedCharged");
                shield.enableShield = nbt.func_74767_n("EnableShield");
                shield.enableDamage = nbt.func_74767_n("EnableDamage");
                ItemStackHelper.func_191283_b((NBTTagCompound)itemStack.func_77978_p(), (NonNullList)shield.inventory);
            }
            if (placer instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)placer;
                shield.ownerUUID = player.func_146103_bH().getId().toString();
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityShieldGenerator) {
            ItemStack machine = new ItemStack((Block)this);
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("ShieldSize", shield.shieldSize);
            nbt.func_74768_a("MaxShieldSize", shield.maxShieldSize);
            nbt.func_74768_a("ShieldDamage", shield.shieldDamage);
            nbt.func_74768_a("MaxShieldDamage", shield.maxShieldDamage);
            nbt.func_74768_a("ShieldCapacity", shield.shieldCapacity);
            nbt.func_74768_a("MaxShieldCapacity", shield.maxShieldCapacity);
            nbt.func_74768_a("ShieldChargeCooldown", shield.shieldChargeCooldown);
            nbt.func_74757_a("NeedCharged", shield.needCharged);
            nbt.func_74757_a("EnableShield", shield.enableShield);
            nbt.func_74757_a("EnableDamage", shield.enableDamage);
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)shield.inventory);
            if (shield.getEnergyStoredGC() > 0.0f) {
                nbt.func_74776_a("EnergyStored", shield.getEnergyStoredGC());
            }
            machine.func_77982_d(nbt);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShieldGenerator) {
            ((TileEntityShieldGenerator)tile).onDestroy(tile);
        }
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityShieldGenerator();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperty.FACING_HORIZON});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)));
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.MACHINE_NON_BLOCK;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(BlocksItemsRegistry.getDescription(this.func_149739_a() + ".description"));
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"0, 255, 207");
    }
}

