/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.tileentity.TileEntitySpaceWarpPadFull;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.TeleportUtils;
import stevekung.mods.moreplanets.utils.blocks.BlockAdvancedTileMP;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class BlockSpaceWarpPadFull
extends BlockAdvancedTileMP
implements IPartialSealableBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);

    public BlockSpaceWarpPadFull(String name) {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
    }

    public int func_149745_a(Random rand) {
        return 9;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMultiBlock) {
            ((IMultiBlock)tile).onDestroy(tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)MPBlocks.SPACE_WARP_PAD);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z2 = -1; z2 < 2; ++z2) {
                if (super.func_176196_c(world, pos.func_177982_a(x2, 0, z2))) continue;
                return false;
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_184138_a(pos, state, state, 3);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.UP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(MPBlocks.SPACE_WARP_PAD);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySpaceWarpPadFull();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntitySpaceWarpPadFull) {
                TileEntitySpaceWarpPadFull warpPad = (TileEntitySpaceWarpPadFull)tile;
                if (!warpPad.disabled) {
                    if (warpPad.hasWarpCore()) {
                        if (warpPad.getDestinationPos() == null) {
                            player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.no_warp_destination.message")).func_150255_a(JsonUtils.red()));
                            return true;
                        }
                        if (warpPad.getEnergyStoredGC() >= 5000.0f) {
                            warpPad.storage.setEnergyStored(warpPad.storage.getEnergyStoredGC() - 5000.0f);
                            TeleportUtils.teleportEntity((Entity)player, warpPad.getDimensionId(), warpPad.getDestinationPos().func_177958_n(), warpPad.getDestinationPos().func_177956_o(), warpPad.getDestinationPos().func_177952_p(), warpPad.getRotationPitch(), warpPad.getRotationYaw());
                            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.75f, 1.0f);
                            LoggerMP.debug("Teleport player to {} {} {} {} {}", warpPad.getDestinationPos().func_177958_n(), warpPad.getDestinationPos().func_177956_o(), warpPad.getDestinationPos().func_177952_p(), warpPad.getDimensionId(), warpPad.getDimensionName());
                            return true;
                        }
                        player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.status.missingpower.name")).func_150255_a(JsonUtils.red()));
                        return true;
                    }
                    player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.status.warp_core_required.name")).func_150255_a(JsonUtils.red()));
                    return true;
                }
                player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.dark_energy_disabled.message")).func_150255_a(JsonUtils.red()));
                return true;
            }
        } else {
            player.openGui((Object)MorePlanetsMod.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }
}

