/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.renderer.sky;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public abstract class SkyProviderBaseMP
extends IRenderHandler {
    private static final String[] starColorHexTable = new String[]{"#9bb2ff", "#9eb5ff", "#a3b9ff", "#aabffir", "#b2c5ff", "#bbccfr", "#c4d2ff", "#ccd8ff", "#d3ddff", "#dae2ff", "#dfe5ff", "#e4e9ff", "#e9ecif", "#eeefff", "#f3f2ff", "#f8f6ff", "#fef9ff", "Off9fb", "#fff7f5", "#ffif5ef", "#fff3ea", "#fffle5", "#ffefe0", "#ffeddb", "#ffebd6", "#ffe9d2", "#ffe8ce", "#ffe6ca", "#ffe5c6", "#ffe3c3", "#ffe2bf", "#ffeObb", "#ffdfb8", "#ffddb4", "#ffdbb0", "#ffdaad", "#ffd8a9", "#ffd6a5", "#ffd5a1", "#ffd29c", "#ffd096", "#ffcc8f", "#ffc885", "#ffc178", "#ffb765", "#ffa94b", "#ff9523"};
    private int starList;
    private int glSkyList;
    private int glSkyList2;
    protected float solarSize;
    protected boolean hasRain;

    public SkyProviderBaseMP() {
        int displayLists;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.starList = displayLists = GLAllocation.func_74526_a((int)3);
        this.glSkyList = displayLists + 1;
        this.glSkyList2 = displayLists + 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_187423_f((int)this.starList, (int)4864);
        this.renderStars();
        GlStateManager.func_187415_K();
        GlStateManager.func_179121_F();
        this.glSkyList = this.starList + 1;
        GlStateManager.func_187423_f((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 256 / byte2 + 2;
        float f = 16.0f;
        for (int j = -byte2 * i; j <= byte2 * i; j += byte2) {
            for (int l = -byte2 * i; l <= byte2 * i; l += byte2) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b((double)(j + 0), (double)f, (double)(l + 0)).func_181675_d();
                buffer.func_181662_b((double)(j + byte2), (double)f, (double)(l + 0)).func_181675_d();
                buffer.func_181662_b((double)(j + byte2), (double)f, (double)(l + byte2)).func_181675_d();
                buffer.func_181662_b((double)(j + 0), (double)f, (double)(l + byte2)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_187415_K();
        this.glSkyList2 = this.starList + 2;
        GlStateManager.func_187423_f((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -byte2 * i; k <= byte2 * i; k += byte2) {
            for (int i1 = -byte2 * i; i1 <= byte2 * i; i1 += byte2) {
                buffer.func_181662_b((double)(k + byte2), (double)f, (double)(i1 + 0)).func_181675_d();
                buffer.func_181662_b((double)(k + 0), (double)f, (double)(i1 + 0)).func_181675_d();
                buffer.func_181662_b((double)(k + 0), (double)f, (double)(i1 + byte2)).func_181675_d();
                buffer.func_181662_b((double)(k + byte2), (double)f, (double)(i1 + byte2)).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_187415_K();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float starBrightness;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Vec3d vec3 = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float red = (float)vec3.field_72450_a;
        float green = (float)vec3.field_72448_b;
        float blue = (float)vec3.field_72449_c;
        GlStateManager.func_179090_x();
        GlStateManager.func_179101_C();
        RenderHelper.func_74519_b();
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        GlStateManager.func_179148_o((int)this.glSkyList);
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] sunsetColors = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (sunsetColors != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)world.func_72826_c(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float sunRed = sunsetColors[0];
            float sunGreen = sunsetColors[1];
            float sunBlue = sunsetColors[2];
            float sunAlpha = sunsetColors[3];
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(sunRed, sunGreen, sunBlue, sunAlpha).func_181675_d();
            for (int j2 = 0; j2 <= 16; ++j2) {
                float f21 = (float)j2 * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                buffer.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * sunAlpha)).func_181666_a(sunRed, sunGreen, sunBlue, 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        float rainStrength = 0.0f;
        if (this.hasRain) {
            rainStrength = 1.0f - world.func_72867_j(partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
        }
        float f = starBrightness = this.hasRain ? world.func_72880_h(partialTicks) * rainStrength : world.func_72880_h(partialTicks);
        if (starBrightness > 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderStars(starBrightness);
            GlStateManager.func_179148_o((int)this.starList);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderObjects(partialTicks, world, mc);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double playerHorizon = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72919_O();
        if (playerHorizon < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            GlStateManager.func_179148_o((int)this.glSkyList2);
            GlStateManager.func_179121_F();
            float f19 = -((float)(playerHorizon + 65.0));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(playerHorizon - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)this.glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    private void renderStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Random rand = new Random(10842L);
        buffer.func_181668_a(7, ConfigManagerMP.moreplanets_general.useColoredStar || ConfigManagerMP.moreplanets_general.useFancyStar ? DefaultVertexFormats.field_181706_f : DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < this.getStarCount(); ++i) {
            double d0 = rand.nextFloat() * 2.0f - 1.0f;
            double d1 = rand.nextFloat() * 2.0f - 1.0f;
            double d2 = rand.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + rand.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * (rand.nextDouble() * this.getStarSpreadMultiplier() + 100.0);
            double d6 = (d1 *= d4) * (rand.nextDouble() * this.getStarSpreadMultiplier() + 100.0);
            double d7 = (d2 *= d4) * (rand.nextDouble() * this.getStarSpreadMultiplier() + 100.0);
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = rand.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                if (ConfigManagerMP.moreplanets_general.useColoredStar) {
                    try {
                        int color = ColorUtils.hexToRgb((String)starColorHexTable[rand.nextInt(starColorHexTable.length)]);
                        int red = ColorUtils.toRGB((int)color).packedRed();
                        int green = ColorUtils.toRGB((int)color).packedGreen();
                        int blue = ColorUtils.toRGB((int)color).packedBlue();
                        buffer.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181669_b(red, green, blue, rand.nextInt(255)).func_181675_d();
                    }
                    catch (Exception e) {
                        buffer.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181669_b(255, 255, 255, rand.nextInt(255)).func_181675_d();
                    }
                } else if (!ConfigManagerMP.moreplanets_general.useFancyStar) {
                    buffer.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
                }
                if (ConfigManagerMP.moreplanets_general.useColoredStar || !ConfigManagerMP.moreplanets_general.useFancyStar) continue;
                buffer.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181669_b(255, 255, 255, rand.nextInt(255)).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    protected void renderSolar(ResourceLocation resource, float scale, boolean renderBlack, boolean renderConceal, float toDivide) {
        this.renderSolar(resource, scale, renderBlack, renderConceal, toDivide, 1.0f);
    }

    protected void renderSolar(ResourceLocation resource, float scale, boolean renderBlack, boolean renderConceal, float toDivide, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        if (renderBlack) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float blackScale = scale / toDivide;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            buffer.func_181662_b((double)(-blackScale), 99.9, (double)(-blackScale)).func_181675_d();
            buffer.func_181662_b((double)blackScale, 99.9, (double)(-blackScale)).func_181675_d();
            buffer.func_181662_b((double)blackScale, 99.9, (double)blackScale).func_181675_d();
            buffer.func_181662_b((double)(-blackScale), 99.9, (double)blackScale).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (renderConceal) {
            float blackScale2 = scale / toDivide;
            GlStateManager.func_179090_x();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            buffer.func_181662_b((double)(-blackScale2), 99.9, (double)(-blackScale2)).func_181675_d();
            buffer.func_181662_b((double)blackScale2, 99.9, (double)(-blackScale2)).func_181675_d();
            buffer.func_181662_b((double)blackScale2, 99.9, (double)blackScale2).func_181675_d();
            buffer.func_181662_b((double)(-blackScale2), 99.9, (double)blackScale2).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        mc.func_110434_K().func_110577_a(resource);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-scale), 100.0, (double)(-scale)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)(-scale)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)scale).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-scale), 100.0, (double)scale).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected void renderSolarAura(float smallAuraScale, float largeAuraScale, float starBrightness, ColorUtils.RGB rgb, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float red = rgb.floatRed();
        float green = rgb.floatGreen();
        float blue = rgb.floatBlue();
        float alpha = rgb.floatAlpha();
        starBrightness = 1.0f - starBrightness;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, alpha * 2.0f / starBrightness).func_181675_d();
        buffer.func_181662_b((double)(-smallAuraScale), 100.0, (double)(-smallAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b(0.0, 100.0, (double)(-smallAuraScale) * 1.5).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)smallAuraScale, 100.0, (double)(-smallAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)smallAuraScale * 1.5, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)smallAuraScale, 100.0, (double)smallAuraScale).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b(0.0, 100.0, (double)smallAuraScale * 1.5).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-smallAuraScale), 100.0, (double)smallAuraScale).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-smallAuraScale) * 1.5, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-smallAuraScale), 100.0, (double)(-smallAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, alpha * starBrightness).func_181675_d();
        buffer.func_181662_b((double)(-largeAuraScale), 100.0, (double)(-largeAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b(0.0, 100.0, (double)(-largeAuraScale) * 1.5).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)largeAuraScale, 100.0, (double)(-largeAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)largeAuraScale * 1.5, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)largeAuraScale, 100.0, (double)largeAuraScale).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b(0.0, 100.0, (double)largeAuraScale * 1.5).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-largeAuraScale), 100.0, (double)largeAuraScale).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-largeAuraScale) * 1.5, 100.0, 0.0).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        buffer.func_181662_b((double)(-largeAuraScale), 100.0, (double)(-largeAuraScale)).func_181666_a(red * starBrightness, green * starBrightness, blue * starBrightness, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    protected void renderObject(float scale, float rot1, float rot2, boolean rotate, ResourceLocation resource, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)rot1, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rot2, (float)1.0f, (float)0.0f, (float)0.0f);
        if (rotate) {
            GlStateManager.func_179114_b((float)(mc.field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        mc.func_110434_K().func_110577_a(resource);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-scale), 100.0, (double)(-scale)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)(-scale)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)scale).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-scale), 100.0, (double)scale).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected void renderObject(float scale, float rot1, float rot2, boolean rotate, ResourceLocation resource, float partialTicks, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)rot1, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rot2, (float)1.0f, (float)0.0f, (float)0.0f);
        if (rotate) {
            GlStateManager.func_179114_b((float)(mc.field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        mc.func_110434_K().func_110577_a(resource);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-scale), 100.0, (double)(-scale)).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)(-scale)).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)scale, 100.0, (double)scale).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-scale), 100.0, (double)scale).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected boolean useDefaultStarBrightness() {
        return false;
    }

    protected abstract void renderObjects(float var1, WorldClient var2, Minecraft var3);

    protected abstract void renderStars(float var1);

    protected abstract int getStarCount();

    protected abstract double getStarSpreadMultiplier();

    protected abstract float getStarBrightness();
}

