/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.handler;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteBomb;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteSlimeBoss;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteSlimeMinion;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteSpider;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteTentacle;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteWorm;
import stevekung.mods.moreplanets.planets.diona.entity.projectile.EntityInfectedPurloniteArrow;
import stevekung.mods.stevekunglib.utils.BlockItemRemapper;
import stevekung.mods.stevekunglib.utils.LoggerSL;

public class MissingMappingHandler {
    @SubscribeEvent
    public void onBlockMissingMappings(RegistryEvent.MissingMappings<Block> event) {
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_web", (Block)MPBlocks.INFECTED_PURLONITE_COBWEB);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"large_infected_crystallized", (Block)MPBlocks.INFECTED_PURLONITE_CRYSTAL);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_segment", (Block)MPBlocks.INFECTED_PURLONITE_SEGMENT);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_eye_core", (Block)MPBlocks.INFECTED_PURLONITE_EYE_CORE);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_ender_core", (Block)MPBlocks.INFECTED_PURLONITE_ENDER_CORE);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_planks", (Block)MPBlocks.INFECTED_PURLONITE_PLANKS);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_fence", (Block)MPBlocks.INFECTED_PURLONITE_FENCE);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_cobweb", (Block)MPBlocks.INFECTED_PURLONITE_COBWEB);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_torch", (Block)MPBlocks.INFECTED_PURLONITE_TORCH);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_crystal", (Block)MPBlocks.INFECTED_PURLONITE_CRYSTAL);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"infected_crystallized_slime_block", (Block)MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"crystallized_water_fluid", (Block)MPBlocks.INFECTED_PURLONITE_WATER_FLUID_BLOCK);
        BlockItemRemapper.remapBlock(event, (String)"moreplanets", (String)"crystallized_lava_fluid", (Block)MPBlocks.INFECTED_PURLONITE_LAVA_FLUID_BLOCK);
    }

    @SubscribeEvent
    public void onItemMissingMappings(RegistryEvent.MissingMappings<Item> event) {
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_web", (Block)MPBlocks.INFECTED_PURLONITE_COBWEB);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"large_infected_crystallized", (Block)MPBlocks.INFECTED_PURLONITE_CRYSTAL);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_segment", (Block)MPBlocks.INFECTED_PURLONITE_SEGMENT);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_eye_core", (Block)MPBlocks.INFECTED_PURLONITE_EYE_CORE);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_ender_core", (Block)MPBlocks.INFECTED_PURLONITE_ENDER_CORE);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_planks", (Block)MPBlocks.INFECTED_PURLONITE_PLANKS);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_fence", (Block)MPBlocks.INFECTED_PURLONITE_FENCE);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_cobweb", (Block)MPBlocks.INFECTED_PURLONITE_COBWEB);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_torch", (Block)MPBlocks.INFECTED_PURLONITE_TORCH);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_crystal", (Block)MPBlocks.INFECTED_PURLONITE_CRYSTAL);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_slime_block", (Block)MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"crystallized_water_fluid", (Block)MPBlocks.INFECTED_PURLONITE_WATER_FLUID_BLOCK);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"crystallized_lava_fluid", (Block)MPBlocks.INFECTED_PURLONITE_LAVA_FLUID_BLOCK);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_laser_bullet", (Item)MPItems.INFECTED_PURLONITE_LASER_BULLET);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_shard", (Item)MPItems.INFECTED_PURLONITE_SHARD);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_bomb", (Item)MPItems.INFECTED_PURLONITE_BOMB);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_slimeball", (Item)MPItems.INFECTED_PURLONITE_SLIMEBALL);
        BlockItemRemapper.remapItem(event, (String)"moreplanets", (String)"infected_crystallized_arrow", (Item)MPItems.INFECTED_PURLONITE_ARROW);
    }

    @SubscribeEvent
    public void onPotionMissingMappings(RegistryEvent.MissingMappings<Potion> event) {
        MissingMappingHandler.remapPotion(event, "moreplanets", "infected_crystallized", MPPotions.INFECTED_PURLONITE);
    }

    @SubscribeEvent
    public void onEntityMissingMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_spider", EntityRegistry.getEntry(EntityInfectedPurloniteSpider.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_worm", EntityRegistry.getEntry(EntityInfectedPurloniteWorm.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_slime_boss", EntityRegistry.getEntry(EntityInfectedPurloniteSlimeBoss.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_slime_minion", EntityRegistry.getEntry(EntityInfectedPurloniteSlimeMinion.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_tentacle", EntityRegistry.getEntry(EntityInfectedPurloniteTentacle.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_bomb", EntityRegistry.getEntry(EntityInfectedPurloniteBomb.class));
        MissingMappingHandler.remapEntity(event, "moreplanets", "infected_crystallized_arrow", EntityRegistry.getEntry(EntityInfectedPurloniteArrow.class));
    }

    private static void remapPotion(RegistryEvent.MissingMappings<Potion> event, String modid, String oldName, Potion potion) {
        event.getMappings().forEach(mappings -> {
            if (mappings.key.func_110624_b().equals(modid) && mappings.key.func_110623_a().equals(oldName)) {
                mappings.remap((IForgeRegistryEntry)potion);
                LoggerSL.info((String)"Remapping 'Potion' from {} to {}", (Object[])new Object[]{mappings.key, potion.getRegistryName()});
            }
        });
    }

    private static void remapEntity(RegistryEvent.MissingMappings<EntityEntry> event, String modid, String oldName, EntityEntry entity) {
        event.getMappings().forEach(mappings -> {
            if (mappings.key.func_110624_b().equals(modid) && mappings.key.func_110623_a().equals(oldName)) {
                mappings.remap((IForgeRegistryEntry)entity);
                LoggerSL.info((String)"Remapping 'Entity' from {} to {}", (Object[])new Object[]{mappings.key, entity.getRegistryName()});
            }
        });
    }
}

