/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.world;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import stevekung.mods.moreplanets.utils.world.gen.ChunkGeneratorBaseMP;
import stevekung.mods.moreplanets.utils.world.gen.feature.WorldGenGlowStone1;
import stevekung.mods.moreplanets.utils.world.gen.feature.WorldGenGlowStone2;

public class ChunkGeneratorSpaceNether
extends ChunkGeneratorBaseMP {
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final WorldGenFire fireFeature = new WorldGenFire();
    private final WorldGenGlowStone1 glowstoneGen1 = new WorldGenGlowStone1();
    private final WorldGenGlowStone2 glowstoneGen2 = new WorldGenGlowStone2();
    private final WorldGenerator quartzGen = new WorldGenMinable(Blocks.field_150449_bY.func_176223_P(), 14, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenerator magmaGen = new WorldGenMinable(Blocks.field_189877_df.func_176223_P(), 33, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenHellLava lavaTrapGen = new WorldGenHellLava((Block)Blocks.field_150356_k, true);
    private final WorldGenHellLava hellSpringGen = new WorldGenHellLava((Block)Blocks.field_150356_k, false);
    private final WorldGenBush brownMushroomFeature = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush redMushroomFeature = new WorldGenBush(Blocks.field_150337_Q);
    private MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private MapGenBase genNetherCaves = new MapGenCavesHell();
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;

    public ChunkGeneratorSpaceNether(World world, long seed) {
        super(world, seed);
        this.isSingleBiomePlanet = true;
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        world.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.genNetherCaves = TerrainGen.getModdedMapGen((MapGenBase)this.genNetherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
    }

    @Override
    protected void preGenerateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        boolean test = false;
        this.createCraters(chunkX, chunkZ, primer);
        if (test) {
            this.prepareHeights(chunkX, chunkZ, primer);
            this.buildSurfaces(chunkX, chunkZ, primer);
        }
    }

    @Override
    protected void generateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.genNetherCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.genNetherBridge.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    protected void populate(BlockPos pos, ChunkPos chunkpos, Biome biome, int chunkX, int chunkZ, int x, int z) {
        int i;
        int i2;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        this.genNetherBridge.func_175794_a(this.world, this.rand, chunkpos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (i2 = 0; i2 < 8; ++i2) {
                this.hellSpringGen.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE)) {
            for (i2 = 0; i2 < this.rand.nextInt(this.rand.nextInt(10) + 1) + 1; ++i2) {
                this.fireFeature.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (i2 = 0; i2 < this.rand.nextInt(this.rand.nextInt(10) + 1); ++i2) {
                this.glowstoneGen1.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
            for (i2 = 0; i2 < 10; ++i2) {
                this.glowstoneGen2.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, chunkpos));
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            if (this.rand.nextBoolean()) {
                this.brownMushroomFeature.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
            if (this.rand.nextBoolean()) {
                this.redMushroomFeature.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.quartzGen, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (i2 = 0; i2 < 16; ++i2) {
                this.quartzGen.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(108) + 10, this.rand.nextInt(16)));
            }
        }
        int i22 = this.world.func_181545_F() / 2 + 1;
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_MAGMA)) {
            for (i = 0; i < 4; ++i) {
                this.magmaGen.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16), i22 - 5 + this.rand.nextInt(10), this.rand.nextInt(16)));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA2)) {
            for (i = 0; i < 16; ++i) {
                this.lavaTrapGen.func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(108) + 10, this.rand.nextInt(16) + 8));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(x, 0, z));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, chunkpos));
    }

    @Override
    protected IBlockState getTopBlock() {
        return Blocks.field_150424_aL.func_176223_P();
    }

    @Override
    protected IBlockState getSubBlock() {
        return Blocks.field_150424_aL.func_176223_P();
    }

    @Override
    protected IBlockState getStoneBlock() {
        return Blocks.field_150424_aL.func_176223_P();
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.genNetherBridge.func_175795_b(pos)) {
                return this.genNetherBridge.func_75059_a();
            }
            if (this.genNetherBridge.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.genNetherBridge.func_75059_a();
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos position, boolean findUnexplored) {
        return "Fortress".equals(name) && this.genNetherBridge != null ? this.genNetherBridge.func_180706_b(world, position, findUnexplored) : null;
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        return "Fortress".equals(name) && this.genNetherBridge != null ? this.genNetherBridge.func_175795_b(pos) : false;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.genNetherBridge.func_186125_a(this.world, x, z, null);
    }

    private void prepareHeights(int chunkX, int chunkZ, ChunkPrimer primer) {
        int j = this.world.func_181545_F() / 2 + 1;
        this.buffer = this.getHeights(this.buffer, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d1 = this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = Blocks.field_150353_l.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    iblockstate = Blocks.field_150424_aL.func_176223_P();
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void buildSurfaces(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                boolean flag = this.slowsandNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = Blocks.field_150424_aL.func_176223_P();
                IBlockState iblockstate1 = Blocks.field_150424_aL.func_176223_P();
                for (int j1 = 127; j1 >= 0; --j1) {
                    if (j1 < 127 - this.rand.nextInt(5) && j1 > this.rand.nextInt(5)) {
                        IBlockState iblockstate2 = primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != Blocks.field_150424_aL) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = Blocks.field_150350_a.func_176223_P();
                                    iblockstate1 = Blocks.field_150424_aL.func_176223_P();
                                } else if (j1 >= i - 4 && j1 <= i + 1) {
                                    iblockstate = Blocks.field_150424_aL.func_176223_P();
                                    iblockstate1 = Blocks.field_150424_aL.func_176223_P();
                                    if (flag1) {
                                        iblockstate = Blocks.field_150351_n.func_176223_P();
                                        iblockstate1 = Blocks.field_150424_aL.func_176223_P();
                                    }
                                    if (flag) {
                                        iblockstate = Blocks.field_150425_aM.func_176223_P();
                                        iblockstate1 = Blocks.field_150425_aM.func_176223_P();
                                    }
                                }
                                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                                    iblockstate = Blocks.field_150353_l.func_176223_P();
                                }
                                i1 = l;
                                if (j1 >= i - 1) {
                                    primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(k, j1, j, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    private double[] getHeights(double[] p_185938_1_, int p_185938_2_, int p_185938_3_, int p_185938_4_, int p_185938_5_, int p_185938_6_, int p_185938_7_) {
        if (p_185938_1_ == null) {
            p_185938_1_ = new double[p_185938_5_ * p_185938_6_ * p_185938_7_];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185938_1_, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 1.0, 0.0, 1.0);
        this.dr = this.depthNoise.func_76304_a(this.dr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 8.555150000000001, 34.2206, 8.555150000000001);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        int i = 0;
        double[] adouble = new double[p_185938_6_];
        for (int j = 0; j < p_185938_6_; ++j) {
            adouble[j] = Math.cos((double)j * Math.PI * 6.0 / (double)p_185938_6_) * 2.0;
            double d2 = j;
            if (j > p_185938_6_ / 2) {
                d2 = p_185938_6_ - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble[n] = adouble[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < p_185938_5_; ++l) {
            for (int i1 = 0; i1 < p_185938_7_; ++i1) {
                for (int k = 0; k < p_185938_6_; ++k) {
                    double d4 = adouble[k];
                    double d5 = this.ar[i] / 512.0;
                    double d6 = this.br[i] / 512.0;
                    double d7 = (this.pnr[i] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > p_185938_6_ - 4) {
                        double d9 = (float)(k - (p_185938_6_ - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    p_185938_1_[i] = d8;
                    ++i;
                }
            }
        }
        return p_185938_1_;
    }
}

