/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JEIRegistryHelper {
    public static IModRegistry registry;
    public static IGuiHelper guiHelper;
    public static IRecipeCategoryRegistration categoryRegistration;
    public static IVanillaRecipeFactory vanillaRecipe;

    public static void registerRecipe(Collection<?> recipes, String recipe) {
        registry.addRecipes(recipes, recipe);
    }

    public static void registerRecipeCategories(IRecipeCategory<?> recipe) {
        categoryRegistration.addRecipeCategories(new IRecipeCategory[]{recipe});
    }

    public static <T> void registerRecipeHandlers(Class<T> recipeClass, IRecipeWrapperFactory<T> recipeWrapper, String recipe) {
        registry.handleRecipes(recipeClass, recipeWrapper, recipe);
    }

    public static void registerStackDisplayRecipe(ItemStack itemStack, String ... recipe) {
        registry.addRecipeCatalyst((Object)itemStack, recipe);
    }

    public static void registerAnvilRecipe(Block repairItem, List<ItemStack> toolList) {
        JEIRegistryHelper.registerAnvilRecipe(Item.func_150898_a((Block)repairItem), toolList);
    }

    public static void registerAnvilRecipe(Item repairItem, List<ItemStack> toolList) {
        for (ItemStack ingredient : toolList) {
            ItemStack damaged1 = ingredient.func_77946_l();
            damaged1.func_77964_b(damaged1.func_77958_k());
            ItemStack damaged2 = ingredient.func_77946_l();
            damaged2.func_77964_b(damaged2.func_77958_k() * 3 / 4);
            ItemStack damaged3 = ingredient.func_77946_l();
            damaged3.func_77964_b(damaged3.func_77958_k() * 2 / 4);
            ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
            recipes.add(vanillaRecipe.createAnvilRecipe(damaged1, Collections.singletonList(new ItemStack(repairItem)), Collections.singletonList(damaged2)));
            recipes.add(vanillaRecipe.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3)));
            JEIRegistryHelper.registerRecipe(recipes, "minecraft.anvil");
        }
    }

    public static void addInfo(Block block, String ... desc) {
        JEIRegistryHelper.addInfo(new ItemStack(block), desc);
    }

    public static void addInfo(Item item, String ... desc) {
        JEIRegistryHelper.addInfo(new ItemStack(item), desc);
    }

    public static void addInfo(ItemStack itemStack, String ... desc) {
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, desc);
    }
}

