/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.itemblocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.blocks.BlockBlackHoleStorage;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.itemblocks.ItemBlockDescriptionTESR;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

public class ItemBlockBlackHoleStorage
extends ItemBlockDescriptionTESR {
    public ItemBlockBlackHoleStorage(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public boolean placeBlockAt(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState state) {
        for (int y = -24; y <= 24; ++y) {
            for (int x = -24; x <= 24; ++x) {
                for (int z = -24; z <= 24; ++z) {
                    BlockPos posAt = pos.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(posAt).func_177230_c();
                    if (block != MPBlocks.BLACK_HOLE_STORAGE) continue;
                    if (world.field_72995_K) {
                        ClientUtils.setOverlayMessage((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"gui.bh_storage.too_close.message")).func_150255_a(JsonUtils.red()));
                    }
                    return false;
                }
            }
        }
        for (int y2 = 0; y2 < 3; ++y2) {
            BlockPos posAt1 = pos.func_177982_a(0, y2, 0);
            Block block1 = world.func_180495_p(posAt1).func_177230_c();
            if (world.func_180495_p(posAt1).func_185904_a() == Material.field_151579_a || block1.func_176200_f((IBlockAccess)world, posAt1)) continue;
            if (world.field_72995_K) {
                ClientUtils.setOverlayMessage((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"gui.warning.noroom")).func_150255_a(JsonUtils.red()));
            }
            return false;
        }
        return super.placeBlockAt(itemStack, player, world, pos, facing, hitX, hitY, hitZ, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        TileEntity tile;
        if (this.func_179223_d() instanceof IDescription && this.func_179223_d() instanceof BlockBlackHoleStorage && (tile = ((BlockBlackHoleStorage)this.func_179223_d()).createTileEntity(null, this.func_179223_d().func_176223_P())) instanceof TileEntityBlackHoleStorage) {
            TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
            if (ClientUtils.isShiftKeyDown()) {
                ((IDescription)this.field_150939_a).getDescription().addDescription(itemStack, list);
            } else if (ClientUtils.isControlKeyDown() && this.hasItemsKey(itemStack)) {
                NonNullList nonNullList = storage.inventory;
                ItemStackHelper.func_191283_b((NBTTagCompound)itemStack.func_77978_p(), (NonNullList)nonNullList);
                int i = 0;
                int j = 0;
                for (ItemStack invStack : nonNullList) {
                    if (invStack.func_190926_b()) continue;
                    ++j;
                    if (i >= 8) continue;
                    ++i;
                    list.add(invStack.func_82833_r() + " x" + invStack.func_190916_E());
                }
                if (j - i > 0) {
                    list.add(TextFormatting.ITALIC + LangUtils.translate((String)"desc.bhs_more.name", (Object[])new Object[]{j - i}));
                }
            } else {
                if (itemStack.func_77942_o()) {
                    NBTTagCompound nbt = itemStack.func_77978_p();
                    String mode = nbt.func_74779_i("Mode").equals("item") ? "Item" : (nbt.func_74779_i("Mode").equals("item_and_xp") ? "Item/EXP" : "EXP");
                    TextFormatting disable = nbt.func_74767_n("Disable") ? TextFormatting.GREEN : TextFormatting.RED;
                    TextFormatting hopper = nbt.func_74767_n("Hopper") ? TextFormatting.GREEN : TextFormatting.RED;
                    list.add(LangUtils.translate((String)"desc.bhs_disable.name") + ": " + disable + nbt.func_74767_n("Disable"));
                    list.add(LangUtils.translate((String)"desc.bhs_hopper.name") + ": " + hopper + nbt.func_74767_n("Hopper"));
                    list.add(LangUtils.translate((String)"desc.bhs_collect_mode.name") + ": " + TextFormatting.AQUA + mode);
                    if (nbt.func_150297_b("XpFluid", 10)) {
                        list.add(LangUtils.translate((String)"desc.bhs_xp.name") + ": " + TextFormatting.GREEN + nbt.func_74775_l("XpFluid").func_74762_e("Amount") + "/" + storage.getMaxXP());
                    }
                    NBTTagList nbtlist = nbt.func_150295_c("Items", 10);
                    int slot = 0;
                    for (int i = 0; i < nbtlist.func_74745_c(); ++i) {
                        nbt = nbtlist.func_150305_b(i);
                        slot = nbt.func_74771_c("Slot");
                        if (slot < 0 || slot >= 108) continue;
                        ++slot;
                    }
                    list.add(LangUtils.translate((String)"desc.bhs_slot_used.name") + ": " + TextFormatting.GOLD + slot + "/" + storage.func_70302_i_());
                }
                list.add(LangUtils.translate((String)"desc.shift_info.name"));
                if (this.hasItemsKey(itemStack)) {
                    list.add(LangUtils.translate((String)"desc.control_info.name"));
                }
            }
        }
    }

    private boolean hasItemsKey(ItemStack itemStack) {
        NBTTagList list;
        int i;
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (itemStack.func_77942_o() && nbt.func_74764_b("Items") && (i = 0) < (list = nbt.func_150295_c("Items", 10)).func_74745_c()) {
            return list.func_150305_b(i).func_74764_b("Slot");
        }
        return false;
    }
}

