/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public class GenLayerNibiruBiome
extends GenLayer {
    private final List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[CachedEnum.biomeValues.length];
    private final ArrayList<BiomeManager.BiomeEntry>[] biomesList = this.setupBiomes();

    public GenLayerNibiruBiome(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
        for (BiomeManager.BiomeType type : CachedEnum.biomeValues) {
            ImmutableList<BiomeManager.BiomeEntry> biomesToAdd = this.getBiomes(type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_DESERT, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_DEAD_SAVANNA, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_PLAINS, 10));
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                if (this.isOcean(k &= 0xFFFFF0FF)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == Biome.func_185362_a((Biome)MPBiomes.GREEN_VEIN_FIELDS)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        if (this.func_75902_a(3) == 0) {
                            aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)MPBiomes.INFECTED_BADLANDS_PLATEAU);
                            continue;
                        }
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)MPBiomes.INFECTED_WOODED_BADLANDS_PLATEAU);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)MPBiomes.INFECTED_JUNGLE);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)MPBiomes.INFECTED_GIANT_TREE_TAIGA);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                aint1[j + i * areaWidth] = k == 4 ? Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome) : Biome.func_185362_a((Biome)MPBiomes.GREEN_VEIN_FIELDS);
            }
        }
        return aint1;
    }

    private ArrayList<BiomeManager.BiomeEntry>[] setupBiomes() {
        ArrayList[] currentBiomes = new ArrayList[CachedEnum.biomeValues.length];
        ArrayList<BiomeManager.BiomeEntry> list = new ArrayList<BiomeManager.BiomeEntry>();
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_FOREST, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_DEAD_DARK_FOREST, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_MOUNTAINS, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_PLAINS, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_SWAMP, 10));
        currentBiomes[BiomeManager.BiomeType.WARM.ordinal()] = new ArrayList(list);
        list.clear();
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_FOREST, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_MOUNTAINS, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_TAIGA, 10));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_PLAINS, 10));
        currentBiomes[BiomeManager.BiomeType.COOL.ordinal()] = new ArrayList(list);
        list.clear();
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_ICE_SPIKES, 30));
        list.add(new BiomeManager.BiomeEntry(MPBiomes.INFECTED_SNOWY_TAIGA, 10));
        currentBiomes[BiomeManager.BiomeType.ICY.ordinal()] = new ArrayList(list);
        list.clear();
        currentBiomes[BiomeManager.BiomeType.DESERT.ordinal()] = new ArrayList(list);
        return currentBiomes;
    }

    private ImmutableList<BiomeManager.BiomeEntry> getBiomes(BiomeManager.BiomeType type) {
        int idx = type.ordinal();
        ArrayList<BiomeManager.BiomeEntry> list = idx >= this.biomesList.length ? null : this.biomesList[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    private BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    private boolean isOcean(int id) {
        return Biome.func_150568_d((int)id) == MPBiomes.INFECTED_OCEAN || Biome.func_150568_d((int)id) == MPBiomes.INFECTED_DEEP_OCEAN;
    }
}

