/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.structure.StructureNibiruStrongholdPieces;
import stevekung.mods.moreplanets.utils.LoggerMP;

public class MapGenNibiruStronghold
extends MapGenStructure {
    public final List<Biome> allowedBiomes;
    private boolean ranBiomeCheck;
    private final ChunkPos[] structureCoords = new ChunkPos[128];
    private final double distance = 32.0;
    private int spread = 3;

    public MapGenNibiruStronghold() {
        this.allowedBiomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || !(biome.func_185355_j() > 0.0f)) continue;
            this.allowedBiomes.add(biome);
        }
    }

    public String func_143025_a() {
        return "NibiruStronghold";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        for (ChunkPos chunkpos : this.structureCoords) {
            if (chunkX != chunkpos.field_77276_a || chunkZ != chunkpos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        Start start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        while (start.func_186161_c().isEmpty() || ((StructureNibiruStrongholdPieces.Stairs2)((Object)start.func_186161_c().get((int)0))).strongholdPortalRoom == null) {
            start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        return start;
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkpos : this.structureCoords) {
            blockpos$mutableblockpos.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double d1 = blockpos$mutableblockpos.func_177951_i((Vec3i)pos);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    private void generatePositions() {
        this.func_143027_a(this.field_75039_c);
        int i = 0;
        for (StructureStart structurestart : this.field_75053_d.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkPos(structurestart.func_143019_e(), structurestart.func_143018_f());
        }
        Random rand = new Random();
        rand.setSeed(this.field_75039_c.func_72905_C());
        double d1 = rand.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.field_75053_d.size();
        if (l < this.structureCoords.length) {
            for (int i1 = 0; i1 < this.structureCoords.length; ++i1) {
                double d0 = 4.0 * this.distance + this.distance * (double)j * 6.0 + (rand.nextDouble() - 0.5) * this.distance * 2.5;
                int j1 = (int)Math.round(Math.cos(d1) * d0);
                int k1 = (int)Math.round(Math.sin(d1) * d0);
                BlockPos blockpos = this.field_75039_c.func_72959_q().func_180630_a((j1 << 4) + 8, (k1 << 4) + 8, 112, this.allowedBiomes, rand);
                if (blockpos != null) {
                    j1 = blockpos.func_177958_n() >> 4;
                    k1 = blockpos.func_177952_p() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkPos(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.spread;
                if (++k != this.spread) continue;
                k = 0;
                this.spread += 2 * this.spread / (++j + 1);
                this.spread = Math.min(this.spread, this.structureCoords.length - i1);
                d1 += rand.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"NibiruStronghold");
        StructureNibiruStrongholdPieces.registerStrongholdPieces();
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random rand, int x, int z) {
            super(x, z);
            LoggerMP.debug("Generate Nibiru Stronghold at {} {}", x * 16, z * 16);
            StructureNibiruStrongholdPieces.prepareStructurePieces();
            StructureNibiruStrongholdPieces.Stairs2 stairs2 = new StructureNibiruStrongholdPieces.Stairs2(rand, (x << 4) + 2, (z << 4) + 2);
            this.field_75075_a.add(stairs2);
            stairs2.func_74861_a(stairs2, this.field_75075_a, rand);
            List<StructureComponent> list = stairs2.pendingChildren;
            while (!list.isEmpty()) {
                int i = rand.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)stairs2, this.field_75075_a, rand);
            }
            this.func_75072_c();
            this.func_75067_a(world, rand, 10);
        }
    }
}

