/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.blocks.BlockShieldGenerator;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class TileEntityShieldGenerator
extends TileEntityDummy
implements IMultiBlock,
IBubbleProvider {
    public int renderTicks;
    public int solarRotate;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float shieldSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRender = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean enableShield = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean enableDamage = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldSize = 16;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldSizeUpgrade;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldCapacity;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldCapacity = 16000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldDamage = 8;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int maxShieldDamage;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int shieldChargeCooldown = 1200;
    public boolean needCharged;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerUUID = "";
    private boolean initialize;
    public static final HashSet<BlockVec3Dim> LOADED_GENERATORS = Sets.newHashSet();

    public TileEntityShieldGenerator() {
        super("container.shield_generator.name");
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.storage.setMaxExtract(250.0f);
        this.storage.setCapacity(100000.0f);
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            LOADED_GENERATORS.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            LOADED_GENERATORS.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            LOADED_GENERATORS.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.func_145843_s();
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            if (this.field_145850_b.func_73046_m().func_71262_S()) {
                networkedList.add(LOADED_GENERATORS.size());
                for (BlockVec3Dim vec3 : LOADED_GENERATORS) {
                    if (vec3 == null) {
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        continue;
                    }
                    networkedList.add(vec3.x);
                    networkedList.add(vec3.y);
                    networkedList.add(vec3.z);
                    networkedList.add(vec3.dim);
                }
            } else {
                networkedList.add(-1);
            }
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        int size;
        if (this.field_145850_b.field_72995_K && (size = dataStream.readInt()) >= 0) {
            LOADED_GENERATORS.clear();
            for (int i = 0; i < size; ++i) {
                int i1 = dataStream.readInt();
                int i2 = dataStream.readInt();
                int i3 = dataStream.readInt();
                int i4 = dataStream.readInt();
                if (i1 == -1 && i2 == -1 && i3 == -1 && i4 == -1) continue;
                LOADED_GENERATORS.add(new BlockVec3Dim(i1, i2, i3, i4));
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (!this.initialize) {
            this.renderTicks += this.field_145850_b.field_73012_v.nextInt(100);
            this.solarRotate += this.field_145850_b.field_73012_v.nextInt(360);
            this.initialize = TileEntityDummy.initialiseMultiTiles(this.func_174877_v(), this.func_145831_w(), this);
        }
        if (this.hasEnoughEnergyToRun && !this.disabled) {
            ++this.solarRotate;
            this.solarRotate %= 360;
            MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_MINER_SPARK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, new Object[]{Float.valueOf(-0.5f)});
            if (this.ticks % 33 == 0) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_GENERATOR_AMBIENT, SoundCategory.BLOCKS, 0.075f, 1.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int count = 0;
            int capacityUpgradeCount = 0;
            if (!((ItemStack)this.getInventory().get(1)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(1)).func_190916_E();
                this.maxShieldDamage = 8 * count;
            } else {
                this.maxShieldDamage = 8;
            }
            if (!((ItemStack)this.getInventory().get(2)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(2)).func_190916_E();
                this.maxShieldSizeUpgrade = 16 + count;
            } else {
                this.maxShieldSizeUpgrade = 16;
            }
            if (!((ItemStack)this.getInventory().get(3)).func_190926_b()) {
                count = ((ItemStack)this.getInventory().get(3)).func_190916_E();
                capacityUpgradeCount = ((ItemStack)this.getInventory().get(3)).func_190916_E();
                this.maxShieldCapacity = 32000 * count;
            } else {
                this.maxShieldCapacity = 16000;
            }
            int sum = (int)((float)this.shieldDamage + this.shieldSize + (float)capacityUpgradeCount) / 2;
            this.storage.setMaxExtract((float)(250 * sum));
            if (!this.needCharged && this.shieldCapacity == 0) {
                this.needCharged = true;
                this.shieldChargeCooldown = 1200;
                if (this.shieldChargeCooldown == 0) {
                    this.shieldCapacity = 100;
                }
            }
            if (!this.disabled && this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun) {
                if (this.shieldSize <= (float)this.maxShieldSize) {
                    this.shieldSize += 0.1f;
                    if (this.shieldChargeCooldown > 0) {
                        --this.shieldChargeCooldown;
                    }
                    if (this.shieldChargeCooldown == 0 && this.ticks % 2 == 0) {
                        this.shieldCapacity += 100;
                        this.needCharged = false;
                    }
                }
            } else {
                this.shieldSize -= 0.1f;
            }
            this.shieldSize = this.shieldSize <= (float)this.maxShieldSize ? Math.min(Math.max(this.shieldSize, 0.0f), (float)this.maxShieldSize) : (this.shieldSize -= 0.1f);
            this.shieldCapacity = Math.min(Math.max(this.shieldCapacity, 0), this.maxShieldCapacity);
        }
        float range = this.shieldSize;
        for (Entity entity : this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range), (double)((float)this.field_174879_c.func_177956_o() + range), (double)((float)this.field_174879_c.func_177952_p() + range)))) {
            if (this.disabled || !this.enableShield || this.shieldCapacity <= 0 || !(entity instanceof EntityArrow && !(((EntityArrow)entity).field_70250_c instanceof EntityPlayer) && !((EntityArrow)entity).field_70254_i || entity instanceof EntityPotion && !(((EntityPotion)entity).func_85052_h() instanceof EntityPlayer) || entity instanceof EntityFireball) && !(entity instanceof EntityShulkerBullet)) continue;
            if (this.field_145850_b instanceof WorldServer) {
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
            }
            float motion = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            this.shieldCapacity = (int)((float)this.shieldCapacity - motion * 2.0f);
            entity.func_70106_y();
        }
    }

    public boolean onActivated(EntityPlayer player) {
        return ((BlockShieldGenerator)MPBlocks.SHIELD_GENERATOR).onMachineActivated(this.field_145850_b, this.mainBlockPosition, MPBlocks.SHIELD_GENERATOR.func_176223_P(), player, player.func_184600_cs(), player.func_184614_ca(), player.func_174811_aO(), 0.0f, 0.0f, 0.0f);
    }

    public void onCreate(World world, BlockPos pos) {
        this.mainBlockPosition = pos;
        this.func_70296_d();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(pos, positions);
        MPBlocks.SHIELD_GENERATOR_DUMMY.makeFakeBlock(world, positions, pos);
    }

    public void onDestroy(TileEntity tile) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.destroyBlock();
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        for (int y = 1; y < 2; ++y) {
            if (placedPosition.func_177956_o() + y > buildHeight) {
                return;
            }
            positions.add(new BlockPos(placedPosition.func_177958_n(), placedPosition.func_177956_o() + y, placedPosition.func_177952_p()));
        }
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public double getPacketRange() {
        return 64.0;
    }

    public int getPacketCooldown() {
        return 1;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setBubbleVisible(nbt.func_74767_n("ShieldVisible"));
        this.shieldSize = nbt.func_74760_g("ShieldSize");
        this.maxShieldSize = nbt.func_74762_e("MaxShieldSize");
        this.shieldDamage = nbt.func_74762_e("ShieldDamage");
        this.maxShieldDamage = nbt.func_74762_e("MaxShieldDamage");
        this.shieldCapacity = nbt.func_74762_e("ShieldCapacity");
        this.maxShieldCapacity = nbt.func_74762_e("MaxShieldCapacity");
        this.shieldChargeCooldown = nbt.func_74762_e("ShieldChargeCooldown");
        this.needCharged = nbt.func_74767_n("NeedCharged");
        this.enableShield = nbt.func_74767_n("EnableShield");
        this.enableDamage = nbt.func_74767_n("EnableDamage");
        this.ownerUUID = nbt.func_74779_i("OwnerUUID");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("ShieldVisible", this.shouldRender);
        nbt.func_74776_a("ShieldSize", this.shieldSize);
        nbt.func_74768_a("MaxShieldSize", this.maxShieldSize);
        nbt.func_74768_a("ShieldDamage", this.shieldDamage);
        nbt.func_74768_a("MaxShieldDamage", this.maxShieldDamage);
        nbt.func_74768_a("ShieldCapacity", this.shieldCapacity);
        nbt.func_74768_a("MaxShieldCapacity", this.maxShieldCapacity);
        nbt.func_74768_a("ShieldChargeCooldown", this.shieldChargeCooldown);
        nbt.func_74757_a("NeedCharged", this.needCharged);
        nbt.func_74757_a("EnableShield", this.enableShield);
        nbt.func_74757_a("EnableDamage", this.enableDamage);
        nbt.func_74778_a("OwnerUUID", this.ownerUUID);
        return nbt;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return itemStack.func_77973_b() == Items.field_151137_ax;
        }
        if (slot == 2) {
            return itemStack.func_77973_b() == Items.field_151079_bi;
        }
        if (slot == 3) {
            return itemStack.func_77973_b() == Items.field_151045_i;
        }
        return slot == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.disabled;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockShieldGenerator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void setBubbleVisible(boolean render) {
        this.shouldRender = render;
    }

    public float getBubbleSize() {
        return this.shieldSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRender;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 261144.0;
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public String getStatus() {
        if (this.getEnergyStoredGC() == 0.0f) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        if (this.needCharged) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.shield_charging.name");
        }
        return TextFormatting.GREEN + LangUtils.translate((String)"gui.status.active.name");
    }

    public boolean isInsideShield(BlockPos pos) {
        double dx = this.field_174879_c.func_177958_n() - pos.func_177958_n();
        double dy = Math.abs(this.field_174879_c.func_177956_o() - pos.func_177956_o());
        double dz = this.field_174879_c.func_177952_p() - pos.func_177952_p();
        return dx * dx + dz * dz <= (double)(this.shieldSize * this.shieldSize) && dy <= (double)this.shieldSize;
    }

    private boolean destroyBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        this.field_145850_b.func_175718_b(2001, this.field_174879_c, Block.func_176210_f((IBlockState)state));
        ItemStack machine = new ItemStack(MPBlocks.SHIELD_GENERATOR);
        TileEntityShieldGenerator shield = this;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("ShieldSize", shield.shieldSize);
        nbt.func_74768_a("MaxShieldSize", shield.maxShieldSize);
        nbt.func_74768_a("ShieldDamage", shield.shieldDamage);
        nbt.func_74768_a("MaxShieldDamage", shield.maxShieldDamage);
        nbt.func_74768_a("ShieldCapacity", shield.shieldCapacity);
        nbt.func_74768_a("MaxShieldCapacity", shield.maxShieldCapacity);
        nbt.func_74768_a("ShieldChargeCooldown", shield.shieldChargeCooldown);
        nbt.func_74757_a("NeedCharged", shield.needCharged);
        nbt.func_74757_a("EnableShield", shield.enableShield);
        nbt.func_74757_a("EnableDamage", shield.enableDamage);
        if (shield.getEnergyStoredGC() > 0.0f) {
            nbt.func_74776_a("EnergyStored", shield.getEnergyStoredGC());
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)shield.inventory);
        machine.func_77982_d(nbt);
        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)machine);
        return this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
    }
}

