/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.datatypes;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.configurate.datatypes.LocationNode;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class WarpNode
extends LocationNode {
    @Setting(value="cost")
    private double cost = -1.0;
    @Setting(value="category")
    @Nullable
    private String category = null;
    @Setting(value="description")
    @Nullable
    private Text description = null;

    public WarpNode() {
    }

    public WarpNode(UUID world, Vector3d length, Vector3d rotation, double cost, String category, Text description) {
        super(world, length, rotation);
        this.cost = cost;
        this.category = category;
        this.description = description;
    }

    public WarpNode(Location<World> location, Vector3d rotation) {
        this(location, rotation, -1);
    }

    private WarpNode(Location<World> location, Vector3d rotation, int cost) {
        super(location, rotation);
        this.cost = cost;
    }

    public WarpNode(Location<World> location) {
        this(location, -1);
    }

    private WarpNode(Location<World> location, int cost) {
        super(location);
        this.cost = cost;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        if (cost < -1.0) {
            this.cost = -1.0;
        }
        this.cost = cost;
    }

    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    public Text getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable Text description) {
        this.description = description;
    }
}

