/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"blockzap", "zapblock"}, basePermission={"nucleus.blockzap.base"}, commandDescriptionKey="blockzap", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.blockzap.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.blockzap.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.blockzap.exempt.cost")})
@EssentialsEquivalent(value={"break"}, isExact=false, notes="Requires co-ordinates, whereas Essentials required you to look at the block.")
public class BlockZapCommand
implements ICommandExecutor<CommandSource> {
    private final String locationKey = "location";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.location((Text)Text.of((String)this.locationKey)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Location<World> location = context.requireOne(this.locationKey, TypeTokens.LOCATION_WORLD);
        if (location.getBlockType() == BlockTypes.AIR) {
            return context.errorResult("command.blockzap.alreadyair", location.getPosition().toString(), ((World)location.getExtent()).getName());
        }
        LiteralText itemText = Text.of((String)location.getBlock().getName());
        if (location.getBlockType().getItem().isPresent()) {
            ItemStack item = ItemStack.builder().fromBlockState(location.getBlock()).build();
            itemText = item.get(Keys.DISPLAY_NAME).orElseGet(() -> Text.of((Translatable)item, (Object[])new Object[0])).toBuilder().onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)item.createSnapshot())).build();
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            if (location.setBlock(BlockTypes.AIR.getDefaultState(), BlockChangeFlags.ALL)) {
                context.sendMessage("command.blockzap.success", Text.of((String)location.getPosition().toString()), Text.of((String)((World)location.getExtent()).getName()), itemText);
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
        }
        return context.errorResult("command.blockzap.fail", location.getPosition().toString(), ((World)location.getExtent()).getName());
    }
}

