/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands.gamemode;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.text.channel.MessageReceiver;

abstract class GamemodeBase<T extends CommandSource>
implements ICommandExecutor<T> {
    private static final Map<String, String> MODE_MAP = new HashMap<String, String>(){
        {
            this.put(GameModes.SURVIVAL.getId(), "nucleus.gamemode.modes.survival");
            this.put(GameModes.CREATIVE.getId(), "nucleus.gamemode.modes.creative");
            this.put(GameModes.ADVENTURE.getId(), "nucleus.gamemode.modes.adventure");
            this.put(GameModes.SPECTATOR.getId(), "nucleus.gamemode.modes.spectator");
        }
    };

    GamemodeBase() {
    }

    ICommandResult baseCommand(ICommandContext<? extends CommandSource> context, Player user, GameMode gm) throws CommandException {
        if (!context.testPermission(MODE_MAP.computeIfAbsent(gm.getId(), key -> {
            String[] keySplit = key.split(":", 2);
            String r = keySplit[keySplit.length - 1].toLowerCase();
            String perm = "nucleus.gamemode.modes." + r;
            MODE_MAP.put((String)key, perm);
            return perm;
        }))) {
            return context.errorResult("command.gamemode.permission", gm.getTranslation().get());
        }
        DataTransactionResult dtr = user.offer(Keys.GAME_MODE, (Object)gm);
        if (dtr.isSuccessful()) {
            if (!context.is(user)) {
                context.sendMessage("command.gamemode.set.other", user.getName(), gm.getName());
            }
            context.sendMessageTo((MessageReceiver)user, "command.gamemode.set.base", gm.getName());
            return context.successResult();
        }
        return context.errorResult("command.gamemode.error", user.getName());
    }
}

