/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands.gamemode;

import io.github.nucleuspowered.nucleus.modules.admin.commands.gamemode.GamemodeBase;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedGameModeArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.NoneThrowOnCompleteArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"gamemode", "gm"}, basePermission={"nucleus.gamemode.base"}, commandDescriptionKey="gamemode", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.gamemode.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.gamemode.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.gamemode.exempt.cost")}, associatedPermissions={"nucleus.gamemode.modes.spectator", "nucleus.gamemode.modes.creative", "nucleus.gamemode.modes.survival", "nucleus.gamemode.modes.adventure", "nucleus.gamemode.others"})
@NonnullByDefault
@EssentialsEquivalent(value={"gamemode", "gm"}, isExact=false, notes="/gm does not toggle between survival and creative, use /gmt for that")
public class GamemodeCommand
extends GamemodeBase<CommandSource> {
    private final String gamemodeKey = "gamemode";
    private final String gamemodeself = "gamemode_self";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.requiringPermission((CommandElement)GenericArguments.seq((CommandElement[])new CommandElement[]{NucleusParameters.ONE_PLAYER.get(serviceCollection), GenericArguments.onlyOne((CommandElement)new ImprovedGameModeArgument((Text)Text.of((String)this.gamemodeKey), serviceCollection))}), (String)"nucleus.gamemode.others"), GenericArguments.onlyOne((CommandElement)new ImprovedGameModeArgument((Text)Text.of((String)this.gamemodeself), serviceCollection)), NoneThrowOnCompleteArgument.INSTANCE})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Optional<GameMode> ogm;
        Player user;
        if (context.hasAny(this.gamemodeself)) {
            user = context.getIfPlayer();
            ogm = context.getOne(this.gamemodeself, GameMode.class);
        } else {
            user = context.getPlayerFromArgs();
            ogm = context.getOne(this.gamemodeKey, GameMode.class);
        }
        if (!ogm.isPresent()) {
            String mode = user.get(Keys.GAME_MODE).orElse(GameModes.SURVIVAL).getName();
            if (context.is(user)) {
                context.sendMessage("command.gamemode.get.base", mode);
            } else {
                context.sendMessage("command.gamemode.get.other", user.getName(), mode);
            }
            return context.successResult();
        }
        GameMode gm = ogm.get();
        return this.baseCommand(context, user, gm);
    }
}

