/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.serializer.TextSerializers;

@Command(aliases={"me", "action"}, basePermission={"nucleus.me.base"}, commandDescriptionKey="me", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.me.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.me.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.me.exempt.cost")})
@EssentialsEquivalent(value={"me", "action", "describe"})
public class MeCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final IChatMessageFormatterService chatMessageFormatterService;
    private ChatConfig config = new ChatConfig();

    @Inject
    public MeCommand(INucleusServiceCollection serviceCollection) {
        this.chatMessageFormatterService = serviceCollection.chatMessageFormatter();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        ITextStyleService textStyleService = context.getServiceCollection().textStyleService();
        String message = textStyleService.stripPermissionless("nucleus.chat.color", "nucleus.chat.style", (Subject)context.getCommandSource(), context.requireOne("message", String.class));
        Text header = this.config.getMePrefix().getForCommandSource(context.getCommandSource());
        ITextStyleService.TextFormat t = textStyleService.getLastColourAndStyle((TextRepresentable)header, null);
        Text originalMessage = TextSerializers.FORMATTING_CODE.deserialize(message);
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter(Text.builder().color(t.colour()).style(new TextStyle[]{t.style()}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(message)}).toText());
        formatter.setHeader((TextRepresentable)Text.of());
        CommandSource src = context.getCommandSource();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             NoExceptionAutoClosable c = this.chatMessageFormatterService.setPlayerNucleusChannelTemporarily(Util.CONSOLE_FAKE_UUID, new MeChannel(header));){
            frame.addContext(EventContexts.SHOULD_FORMAT_CHANNEL, (Object)false);
            if (frame.getCurrentCause().root() != src) {
                frame.pushCause((Object)src);
            }
            MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat((Cause)frame.getCurrentCause(), (MessageChannel)src.getMessageChannel(), Optional.of(src.getMessageChannel()), (MessageEvent.MessageFormatter)formatter, (Text)originalMessage, (boolean)false);
            if (Sponge.getEventManager().post((Event)event)) {
                ICommandResult iCommandResult = context.errorResult("command.me.cancel", new Object[0]);
                return iCommandResult;
            }
            event.getChannel().orElse(MessageChannel.TO_ALL).send((Object)src, Util.applyChatTemplate(event.getFormatter()), ChatTypes.CHAT);
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.config = serviceCollection.moduleDataProvider().getModuleConfig(ChatConfig.class);
    }

    public static class MeChannel
    implements IChatMessageFormatterService.Channel {
        private final Text header;

        private MeChannel(Text header) {
            this.header = header;
        }

        @Override
        public boolean willFormat() {
            return true;
        }

        @Override
        public void formatMessageEvent(CommandSource source, MessageEvent.MessageFormatter formatters) {
            formatters.setHeader((TextRepresentable)Text.of((Object[])new Object[]{formatters.getHeader(), this.header}));
        }

        @Override
        public Collection<MessageReceiver> receivers() {
            return MessageChannel.TO_ALL.getMembers();
        }
    }
}

