/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.interfaces.IModuleDataProvider;
import java.util.Collection;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"nucleus"}, basePermission={"nucleus.nucleus.base"}, commandDescriptionKey="nucleus", prefixAliasesWithN=false)
@NonnullByDefault
public class NucleusCommand
implements ICommandExecutor<CommandSource> {
    private final Text version = Text.of((Object[])new Object[]{TextColors.GREEN, "Nucleus version 2.4.0 (built from commit d4ec0f9e9)"});
    @Nullable
    private Text modules = null;

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        if (this.modules == null) {
            LiteralText.Builder tb = Text.builder((String)"Modules: ").color(TextColors.GREEN);
            boolean addComma = false;
            IModuleDataProvider dataProvider = context.getServiceCollection().moduleDataProvider();
            Collection<String> enabled = dataProvider.getModules(Tristate.TRUE);
            for (String module : dataProvider.getModules(Tristate.UNDEFINED)) {
                if (addComma) {
                    tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, ", "})});
                }
                tb.append(new Text[]{Text.of((Object[])new Object[]{enabled.contains(module) ? TextColors.GREEN : TextColors.RED, module})});
                addComma = true;
            }
            this.modules = tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "."})}).build();
        }
        context.getCommandSource().sendMessage(this.version);
        context.getCommandSource().sendMessage(this.modules);
        return context.successResult();
    }
}

