/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.experience.commands;

import io.github.nucleuspowered.nucleus.modules.experience.commands.ExperienceCommand;
import io.github.nucleuspowered.nucleus.modules.experience.parameter.ExperienceLevelArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"give"}, parentCommand=ExperienceCommand.class, basePermission={"nucleus.exp.give.base"}, commandDescriptionKey="exp.give")
@NonnullByDefault
public class GiveExperience
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_PLAYER.get(serviceCollection), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new ExperienceLevelArgument((Text)Text.of((String)"level"), serviceCollection)), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)"experience"), serviceCollection))})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        int extra;
        Player pl = context.getPlayerFromArgs();
        Optional<ICommandResult> res = ExperienceCommand.checkGameMode(context, pl);
        if (res.isPresent()) {
            return res.get();
        }
        if (context.hasAny("level")) {
            int lvl = pl.get(Keys.EXPERIENCE_LEVEL).orElse(0) + context.requireOne("level", Integer.TYPE);
            extra = pl.get(Keys.EXPERIENCE_SINCE_LEVEL).orElse(0);
            pl.tryOffer(Keys.EXPERIENCE_LEVEL, (Object)lvl);
        } else {
            extra = context.requireOne("experience", Integer.TYPE);
        }
        int exp = (Integer)pl.get(Keys.TOTAL_EXPERIENCE).get();
        return ExperienceCommand.tellUserAboutExperience(context, pl, pl.offer(Keys.TOTAL_EXPERIENCE, (Object)(exp += extra)).isSuccessful());
    }
}

