/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@EssentialsEquivalent(value={"lightning", "strike", "smite", "thor", "shock"}, isExact=false, notes="Selectors can be used, entities can be struck.")
@Command(aliases={"lightning", "strike", "smite", "thor", "shock"}, basePermission={"nucleus.lightning.base"}, commandDescriptionKey="lightning", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.lightning.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.lightning.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.lightning.exempt.cost")}, associatedPermissions={"nucleus.lightning.others"})
public class LightningCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optional((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(NucleusParameters.MANY_LIVING.get(serviceCollection), "nucleus.lightning.others", false))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Collection<Living> playerCollection = context.getAll("subject", Living.class);
        if (playerCollection.isEmpty()) {
            Player pl = context.getIfPlayer();
            BlockRay playerBlockRay = BlockRay.from((Entity)pl).distanceLimit(100.0).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
            Optional obh = playerBlockRay.end();
            Location lightningLocation = obh.map(BlockRayHit::getLocation).orElseGet(() -> pl.getLocation().add(0.0, 3.0, 0.0));
            this.spawnLightning((Location<World>)lightningLocation, context, null);
            return context.successResult();
        }
        for (Living pl : playerCollection) {
            this.spawnLightning((Location<World>)pl.getLocation(), context, pl instanceof Player ? (Player)pl : null);
        }
        return context.successResult();
    }

    private void spawnLightning(Location<World> location, ICommandContext<? extends CommandSource> context, @Nullable Player target) throws CommandException {
        World world = (World)location.getExtent();
        Entity bolt = world.createEntity(EntityTypes.LIGHTNING, location.getPosition());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            world.spawnEntity(bolt);
            if (target != null) {
                context.sendMessage("command.lightning.success.other", context.getServiceCollection().playerDisplayNameService().getDisplayName(target.getUniqueId()));
            }
        }
        if (target != null) {
            throw context.createException("command.lightning.errorplayer", context.getServiceCollection().playerDisplayNameService().getDisplayName(target.getUniqueId()));
        }
        throw context.createException("command.lightning.error", new Object[0]);
    }
}

