/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveDoubleArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.explosion.Explosion;

@NonnullByDefault
@Command(aliases={"rocket"}, basePermission={"nucleus.rocket.base"}, commandDescriptionKey="rocket", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.rocket.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.rocket.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.rocket.exempt.cost")}, associatedPermissions={"nucleus.rocket.others"})
public class RocketCommand
implements ICommandExecutor<CommandSource> {
    private final String velocity = "velocity";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"h", "-hard"}).flag(new String[]{"g", "-g"}).valueFlag((CommandElement)new PositiveDoubleArgument((Text)Text.of((String)this.velocity), serviceCollection), new String[]{"v", "-velocity"}).flag(new String[]{"s", "-silent"}).flag(new String[]{"e", "-explosion"}).buildWith(NucleusParameters.ONE_PLAYER.get(serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player target = context.getPlayerFromArgs();
        boolean isSelf = context.is(target);
        if (!isSelf && !context.testPermission("nucleus.rocket.others")) {
            return context.errorResult("command.rocket.noothers", new Object[0]);
        }
        double v = 2.0;
        if (context.hasAny(this.velocity)) {
            v = context.requireOne(this.velocity, Double.TYPE);
        } else if (context.hasAny("g")) {
            v = 0.5;
        } else if (context.hasAny("h")) {
            v = 4.0;
        }
        if (context.hasAny("e")) {
            Explosion ex = Explosion.builder().canCauseFire(false).location(target.getLocation()).shouldBreakBlocks(false).shouldPlaySmoke(true).shouldDamageEntities(false).radius((float)v * 2.0f).build();
            ex.getWorld().triggerExplosion(ex);
            Sponge.getScheduler().createSyncExecutor((Object)context.getServiceCollection().pluginContainer()).schedule(() -> ex.getWorld().playSound(SoundTypes.ENTITY_FIREWORK_LAUNCH, target.getLocation().getPosition(), 2.0), 500L, TimeUnit.MILLISECONDS);
        }
        Vector3d velocity = new Vector3d(0.0, v, 0.0);
        target.offer(Keys.VELOCITY, (Object)velocity);
        if (!context.hasAny("s")) {
            context.sendMessageTo((MessageReceiver)target, "command.rocket.self", new Object[0]);
        }
        if (!isSelf) {
            context.sendMessage("command.rocket.other", target.getName());
        }
        return context.successResult();
    }
}

