/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"limit"}, basePermission={"nucleus.home.limit.base"}, commandDescriptionKey="home.limit", parentCommand=HomeCommand.class, async=true, associatedPermissions={"nucleus.home.limit.others"})
public class HomeLimitCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(false, "nucleus.home.limit.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.getUserFromArgs();
        HomeService service = context.getServiceCollection().getServiceUnchecked(HomeService.class);
        int current = service.getHomeCount(user);
        int max = service.getMaximumHomes(user);
        if (context.is(user)) {
            if (max == Integer.MAX_VALUE) {
                context.sendMessage("command.home.limit.selfu", current);
            } else {
                context.sendMessage("command.home.limit.self", current, max);
            }
        } else if (max == Integer.MAX_VALUE) {
            context.sendMessage("command.home.limit.otheru", user.getName(), current);
        } else {
            context.sendMessage("command.home.limit.other", user.getName(), current, max);
        }
        return context.successResult();
    }
}

