/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.api.module.home.data.Home;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.parameters.HomeOtherArgument;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"other", "#homeother"}, basePermission={"nucleus.home.other.base"}, commandDescriptionKey="home.other", parentCommand=HomeCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.home.other.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.home.other.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.home.other.exempt.cost")})
public class HomeOtherCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private final String home = "home";
    private boolean isSafeTeleport = true;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isSafeTeleport = serviceCollection.moduleDataProvider().getModuleConfig(HomeConfig.class).isSafeTeleport();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)new HomeOtherArgument((Text)Text.of((String)this.home), serviceCollection.getServiceUnchecked(HomeService.class), serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player player;
        Home wl = context.requireOne(this.home, Home.class);
        HomeService service = context.getServiceCollection().getServiceUnchecked(HomeService.class);
        TeleportResult result = service.warpToHome(player = context.getIfPlayer(), wl, this.isSafeTeleport);
        if (result.isSuccessful()) {
            context.sendMessage("command.homeother.success", wl.getUser().getName(), wl.getName());
            return context.successResult();
        }
        return context.errorResult("command.homeother.fail", wl.getUser().getName(), wl.getName());
    }
}

