/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.commands;

import io.github.nucleuspowered.nucleus.io.TextFileController;
import io.github.nucleuspowered.nucleus.modules.info.config.InfoConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"motd"}, async=true, basePermission={"nucleus.motd.base"}, commandDescriptionKey="motd")
@EssentialsEquivalent(value={"motd"})
public class MotdCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private Text title = Text.EMPTY;
    private boolean usePagination = true;

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Optional<TextFileController> otfc = context.getServiceCollection().textFileControllerCollection().get("motd");
        if (!otfc.isPresent()) {
            return context.errorResult("command.motd.nocontroller", new Object[0]);
        }
        CommandSource src = context.getCommandSource();
        if (this.usePagination) {
            otfc.get().sendToPlayer(src, this.title);
        } else {
            otfc.get().getTextFromNucleusTextTemplates(src).forEach(arg_0 -> ((CommandSource)src).sendMessage(arg_0));
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        InfoConfig config = serviceCollection.moduleDataProvider().getModuleConfig(InfoConfig.class);
        String title = config.getMotdTitle();
        this.title = title.isEmpty() ? Text.EMPTY : TextSerializers.FORMATTING_CODE.deserialize(title);
        this.usePagination = config.isMotdUsePagination();
    }
}

