/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.inventory.events.ClearInventoryEvent;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"clear", "clearinv", "clearinventory", "ci", "clearinvent"}, basePermission={"nucleus.clear.base"}, commandDescriptionKey="clear", associatedPermissions={"nucleus.clear.others"})
@EssentialsEquivalent(value={"clearinventory", "ci", "clean", "clearinvent"})
public class ClearInventoryCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"a", "-all"}).buildWith(GenericArguments.optional((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(NucleusParameters.ONE_USER.get(serviceCollection), "nucleus.clear.others", false)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User user = context.getUserFromArgs();
        boolean all = context.hasAny("a");
        User target = user.getPlayer().isPresent() ? (User)user.getPlayer().get() : user;
        try {
            return this.clear(context, target, all);
        }
        catch (UnsupportedOperationException ex) {
            return context.errorResult("command.clearinventory.offlinenotsupported", new Object[0]);
        }
    }

    private ICommandResult clear(ICommandContext<? extends CommandSource> context, User target, boolean all) {
        if (Sponge.getEventManager().post((Event)new ClearInventoryEvent.Pre(Sponge.getCauseStackManager().getCurrentCause(), target, all))) {
            return context.errorResult("command.clearinventory.cancelled", target.getName());
        }
        if (all) {
            target.getInventory().clear();
        } else {
            Util.getStandardInventory((Carrier)target).clear();
        }
        Sponge.getEventManager().post((Event)new ClearInventoryEvent.Post(Sponge.getCauseStackManager().getCurrentCause(), target, all));
        context.sendMessage("command.clearinventory.success", target.getName());
        return context.successResult();
    }
}

