/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.commands;

import io.github.nucleuspowered.nucleus.modules.inventory.config.InventoryConfig;
import io.github.nucleuspowered.nucleus.modules.inventory.listeners.InvSeeListener;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"invsee"})
@Command(aliases={"invsee"}, basePermission={"nucleus.invsee.base"}, commandDescriptionKey="invsee", associatedPermissions={"nucleus.invsee.exempt.target", "nucleus.invsee.exempt.interact", "nucleus.invsee.modify", "nucleus.invsee.offline"})
@NonnullByDefault
public class InvSeeCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private boolean self = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_USER.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        User target = context.requireOne("user", User.class);
        if (!target.isOnline() && !context.testPermission("nucleus.invsee.offline")) {
            return context.errorResult("command.invsee.nooffline", new Object[0]);
        }
        if (!this.self && context.is(target)) {
            return context.errorResult("command.invsee.self", new Object[0]);
        }
        if (context.testPermissionFor((Subject)target, "nucleus.invsee.exempt.target")) {
            return context.errorResult("command.invsee.targetexempt", target.getName());
        }
        try {
            Player src = context.getIfPlayer();
            CarriedInventory targetInv = target.isOnline() ? ((Player)target.getPlayer().get()).getInventory() : target.getInventory();
            Optional oc = src.openInventory((Inventory)targetInv);
            if (oc.isPresent()) {
                if (!context.testPermission("nucleus.invsee.modify") || context.testPermissionFor((Subject)target, "nucleus.invsee.exempt.interact")) {
                    InvSeeListener.addEntry(src.getUniqueId(), (Container)oc.get());
                }
                return context.successResult();
            }
            return context.errorResult("command.invsee.failed", new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            return context.errorResult("command.invsee.offlinenotsupported", new Object[0]);
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.self = serviceCollection.moduleDataProvider().getModuleConfig(InventoryConfig.class).isAllowInvseeOnSelf();
    }
}

