/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.jail.JailParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserCacheService;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"checkjailed"}, basePermission={"nucleus.checkjailed.base"}, async=true, commandDescriptionKey="checkjailed")
public class CheckJailedCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{JailParameters.OPTIONAL_JAIL.get(serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Optional<NamedLocation> jail = context.getOne("jail", NamedLocation.class);
        IUserCacheService userCacheService = context.getServiceCollection().userCacheService();
        List usersInJail = jail.map(x -> userCacheService.getJailedIn(x.getName())).orElseGet(userCacheService::getJailed);
        String jailName = jail.map(NamedLocation::getName).orElseGet(() -> context.getMessageString("standard.alljails", new Object[0]));
        if (usersInJail.isEmpty()) {
            context.sendMessage("command.checkjailed.none", jailName);
            return context.successResult();
        }
        CommandSource src = context.getCommandSource();
        Util.getPaginationBuilder(src).title(context.getMessage("command.checkjailed.header", jailName)).contents((Iterable)usersInJail.stream().map(x -> {
            Text name;
            try {
                name = context.getDisplayName((UUID)x);
            }
            catch (IllegalArgumentException ex) {
                name = Text.of((Object[])new Object[]{"unknown: ", x.toString()});
            }
            return name.toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.checkjailed.hover", new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkjail " + x.toString()))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)src);
        return context.successResult();
    }
}

