/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.listeners;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.module.spawn.event.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.teleport.event.NucleusTeleportEvent;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.core.events.NucleusOnLoginEvent;
import io.github.nucleuspowered.nucleus.modules.fly.FlyKeys;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class JailListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final IPermissionService permissionService;
    private final IMessageProviderService messageProviderService;
    private final IPlayerDisplayNameService playerDisplayNameService;
    private final JailHandler handler;
    private List<String> allowedCommands;
    private PluginContainer pluginContainer;

    @Inject
    public JailListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
        this.messageProviderService = serviceCollection.messageProvider();
        this.playerDisplayNameService = serviceCollection.playerDisplayNameService();
        this.handler = serviceCollection.getServiceUnchecked(JailHandler.class);
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    @Listener
    public void onPlayerLogin(NucleusOnLoginEvent event, @Getter(value="getTargetUser") User user, @Getter(value="getUserService") IUserDataObject qs) {
        Optional<JailData> optionalJailData = this.handler.getPlayerJailDataInternal(user);
        if (!optionalJailData.isPresent()) {
            return;
        }
        JailData jd = optionalJailData.get();
        Optional<NamedLocation> owl = this.handler.getWarpLocation(user);
        if (!owl.isPresent()) {
            new PermissionMessageChannel(this.permissionService, "nucleus.jail.notify").send(Text.of((Object[])new Object[]{TextColors.RED, "WARNING: No jail is defined. Jailed players are going free!"}));
            this.handler.unjailPlayer(user);
            return;
        }
        event.setTo(owl.get().getTransform().get());
        if (this.handler.shouldJailOnNextLogin(user)) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContexts.IS_JAILING_ACTION, (Object)true);
                if (event.getFrom().equals(owl.get().getTransform().get())) {
                    jd.setPreviousLocation((Location<World>)event.getFrom().getLocation());
                }
                this.handler.updateJailData(user, jd);
                qs.set(FlyKeys.FLY_TOGGLE, false);
            }
        }
    }

    @Listener(order=Order.LATE)
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        Player user = event.getTargetEntity();
        Optional<JailData> data = this.handler.getPlayerJailDataInternal((User)user);
        if (this.handler.shouldJailOnNextLogin((User)user) && data.isPresent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContexts.IS_JAILING_ACTION, (Object)true);
                NamedLocation owl = this.handler.getWarpLocation((User)user).get();
                JailData jd = data.get();
                Optional<Duration> timeLeft = jd.getRemainingTime();
                Text message = timeLeft.map(duration -> this.messageProviderService.getMessageFor(user.getLocale(), "command.jail.jailedfor", owl.getName(), this.playerDisplayNameService.getDisplayName(jd.getJailerInternal()), this.messageProviderService.getTimeString(user.getLocale(), duration.getSeconds()))).orElseGet(() -> this.messageProviderService.getMessageFor((CommandSource)user, "command.jail.jailedperm", owl.getName(), this.playerDisplayNameService.getDisplayName(jd.getJailerInternal()), "", ""));
                user.sendMessage(message);
                this.messageProviderService.sendMessageTo((CommandSource)user, "standard.reasoncoloured", jd.getReason());
            }
        }
        this.handler.setJailOnNextLogin((User)user, false);
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            Optional<JailData> omd = this.handler.getPlayerJailDataInternal((User)user);
            if (omd.isPresent()) {
                JailData md = omd.get();
                md.nextLoginToTimestamp();
                if (md.expired()) {
                    this.handler.unjailPlayer((User)user);
                } else {
                    this.handler.onJail(md, event.getTargetEntity());
                }
            }
        }).submit((Object)this.pluginContainer);
    }

    @Listener
    public void onRequestSent(NucleusTeleportEvent.Request event, @Root Player cause, @Getter(value="getTargetEntity") Player player) {
        if (this.handler.isPlayerJailed((User)cause)) {
            event.setCancelled(true);
            event.setCancelMessage(this.messageProviderService.getMessageFor(cause.getLocale(), "jail.teleportcause.isjailed"));
        } else if (this.handler.isPlayerJailed((User)player)) {
            event.setCancelled(true);
            event.setCancelMessage(this.messageProviderService.getMessageFor(cause.getLocale(), "jail.teleporttarget.isjailed", player.getName()));
        }
    }

    @Listener
    public void onAboutToTeleport(NucleusTeleportEvent.AboutToTeleport event, @Root CommandSource cause, @Getter(value="getTargetEntity") Player player) {
        if (event.getCause().getContext().get(EventContexts.IS_JAILING_ACTION).orElse(false).booleanValue() && this.handler.isPlayerJailed((User)player)) {
            if (!this.permissionService.hasPermission((Subject)cause, "nucleus.jail.teleportjailed")) {
                event.setCancelled(true);
                event.setCancelMessage(this.messageProviderService.getMessageFor(cause, "jail.abouttoteleporttarget.isjailed", player.getName()));
            } else if (!this.permissionService.hasPermission((Subject)cause, "nucleus.jail.teleporttojailed")) {
                event.setCancelled(true);
                event.setCancelMessage(this.messageProviderService.getMessageFor(cause, "jail.abouttoteleportcause.targetisjailed", player.getName()));
            }
        }
    }

    @Listener
    public void onCommand(SendCommandEvent event, @Root Player player) {
        if (this.handler.checkJail((User)player, false) && this.allowedCommands.stream().noneMatch(x -> event.getCommand().equalsIgnoreCase((String)x))) {
            event.setCancelled(true);
            this.handler.checkJail((User)player, true);
        }
    }

    @Listener
    public void onBlockChange(ChangeBlockEvent event, @Root Player player) {
        event.setCancelled(this.handler.checkJail((User)player, true));
    }

    @Listener
    public void onInteract(InteractEvent event, @Root Player player) {
        event.setCancelled(this.handler.checkJail((User)player, true));
    }

    @Listener
    public void onSpawn(RespawnPlayerEvent event) {
        if (this.handler.checkJail((User)event.getTargetEntity(), false)) {
            event.setToTransform(event.getToTransform().setLocation(this.handler.getWarpLocation((User)event.getTargetEntity()).get().getLocation().get()));
        }
    }

    @Listener
    public void onSendToSpawn(NucleusSendToSpawnEvent event, @Getter(value="getTargetUser") User user) {
        if (this.handler.checkJail(user, false)) {
            event.setCancelled(true);
            event.setCancelReason(this.messageProviderService.getMessageString(event.getCause().first(CommandSource.class).orElseGet(() -> ((Server)Sponge.getServer()).getConsole()), "jail.isjailed", new String[0]));
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.allowedCommands = serviceCollection.moduleDataProvider().getModuleConfig(JailConfig.class).getAllowedCommands();
    }
}

