/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.KitKeys;
import io.github.nucleuspowered.nucleus.modules.kit.KitPermissions;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"list", "ls", "#kits"}, async=true, basePermission={"nucleus.kit.list.base"}, commandDescriptionKey="kit.list", parentCommand=KitCommand.class, associatedPermissions={"nucleus.kit.showhidden"})
@NonnullByDefault
public class KitListCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        KitService service = context.getServiceCollection().getServiceUnchecked(KitService.class);
        Set<String> kits = service.getKitNames();
        if (kits.isEmpty()) {
            return context.errorResult("command.kit.list.empty", new Object[0]);
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
        ArrayList kitText = Lists.newArrayList();
        Map redeemed = context.is(Player.class) ? (Map)((IUserDataObject)context.getServiceCollection().storageManager().getUserService().getOrNewOnThread(context.getIfPlayer().getUniqueId())).getNullable(KitKeys.REDEEMED_KITS) : null;
        boolean showHidden = context.testPermission("nucleus.kit.showhidden");
        service.getKitNames(showHidden).stream().filter(kit -> context.testPermission(KitPermissions.getKitPermission(kit.toLowerCase()))).forEach(kit -> kitText.add(this.createKit(context, redeemed, (String)kit, service.getKit((String)kit).get())));
        PaginationList.Builder paginationBuilder = paginationService.builder().contents((Iterable)kitText).title(context.getMessage("command.kit.list.kits", new Object[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"}));
        paginationBuilder.sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text createKit(ICommandContext<? extends CommandSource> context, @Nullable Map<String, Instant> user, String kitName, Kit kitObj) {
        Instant lastRedeem;
        LiteralText.Builder tb = Text.builder((String)kitName);
        if (user != null && (lastRedeem = user.get(kitName.toLowerCase())) != null) {
            Instant next;
            if (kitObj.isOneTime() && !context.testPermission("nucleus.kit.exempt.onetime")) {
                return tb.color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.list.onetime", kitName))).style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build();
            }
            Duration interval = kitObj.getCooldown().orElse(Duration.ZERO);
            if (!interval.isZero() && !context.testPermission("nucleus.kit.exempt.cooldown") && (next = lastRedeem.plus(interval)).isAfter(Instant.now())) {
                String time = context.getTimeString(Duration.between(Instant.now(), next));
                return tb.color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.list.interval", kitName, time))).style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build();
            }
        }
        Text.Builder builder = tb.color(TextColors.AQUA).onClick((ClickAction)TextActions.runCommand((String)("/kit \"" + kitName + "\""))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.list.text", kitName))).style(new TextStyle[]{TextStyles.ITALIC});
        IEconomyServiceProvider economyServiceProvider = context.getServiceCollection().economyServiceProvider();
        if (kitObj.getCost() > 0.0 && economyServiceProvider.serviceExists() && !context.testPermission("nucleus.kit.exempt.cost")) {
            builder = Text.builder().append(new Text[]{builder.build()}).append(new Text[]{context.getMessage("command.kit.list.cost", economyServiceProvider.getCurrencySymbol(kitObj.getCost()))});
        }
        return builder.build();
    }
}

